/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

public class Pager {
    private String firstPageText;
    private String lastPageText;
    private String currentPageText;
    private String nextPageText;
    private String endPageText;
    private String controlBarText;
    private int size;
    private int pagesCount;
    private int pageSize;
    private int currentPage;
    private int startIndex;

    public Pager() {
    }

    public Pager(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setCurrentPage(int page) {
        this.currentPage = page;
    }

    public void setListSize(int size) {
        this.size = size;
        this.startIndex = (this.currentPage - 1) * this.pageSize + 1;
        int n = this.size % this.pageSize == 0 ? 0 : 1;
        this.pagesCount = n == 0 ? (this.size - this.size % this.pageSize) / this.pageSize : (this.size - this.size % this.pageSize) / this.pageSize + n;
    }

    public int getSize() {
        return this.size;
    }

    public String getPageControlNumber(String page) {
        StringBuilder pageControlBar = new StringBuilder();
        for (int i = 1; i <= this.pagesCount; ++i) {
            pageControlBar.append(" <a href=\"").append(page).append("=").append(i).append("\">").append(i).append("</a> ");
        }
        return pageControlBar.toString();
    }

    public void setFirstPageText(String text) {
        this.firstPageText = text;
    }

    public void setLastPageText(String text) {
        this.lastPageText = text;
    }

    public void setCurrentPageText(String text) {
        this.currentPageText = text;
    }

    public void setNextPageText(String text) {
        this.nextPageText = text;
    }

    public void setEndPageText(String text) {
        this.endPageText = text;
    }

    public void setControlBarText(String text) {
        this.controlBarText = text;
    }

    public String getPageControlBar(String page) {
        String theFirstPageLink = page + "=1";
        String theLastPageLink = page + "=" + (this.currentPage - 1);
        String theCurrentPageLink = page + "=" + this.currentPage;
        String theNextPageLink = page + "=" + (this.currentPage + 1);
        String theEndPageLink = page + "=" + this.pagesCount;
        String theFirstPage = this.currentPage > 1 ? "<a href=\"" + theFirstPageLink + "\">" + this.firstPageText + "</a>" : this.firstPageText;
        String theLastPage = this.currentPage > 1 ? "<a href=\"" + theLastPageLink + "\">" + this.lastPageText + "</a>" : this.lastPageText;
        String theCurrentPageText = "[<a href=\"" + theCurrentPageLink + "\">" + this.currentPage + "</a>]";
        String theCurrentPage = String.format(this.currentPageText, theCurrentPageText);
        String theNextPage = this.currentPage < this.pagesCount ? "<a href=\"" + theNextPageLink + "\">" + this.nextPageText + "</a>" : this.nextPageText;
        String theEndPage = this.currentPage < this.pagesCount ? "<a href=\"" + theEndPageLink + "\">" + this.endPageText + "</a>" : this.endPageText;
        Object[] args = new Object[]{this.pagesCount, this.pageSize, this.size, theFirstPage, theLastPage, theCurrentPage, theNextPage, theEndPage};
        return "<div class=\"pageControl\">" + String.format(this.controlBarText, args) + "</div>";
    }
}

