/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.data.Repository;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.data.component.FieldType;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.Table;

public class SQLServer
implements Repository {
    @Override
    public boolean append(Field ready_fields, String table) throws ApplicationException {
        boolean inserted = false;
        Object SQL = "";
        StringBuilder keys = new StringBuilder();
        StringBuilder dataKeys = new StringBuilder();
        StringBuilder values = new StringBuilder();
        StringBuilder parameters = new StringBuilder();
        String dot = ",";
        Enumeration _field = ready_fields.keys();
        while (_field.hasMoreElements()) {
            String currentProperty = (String)_field.nextElement();
            FieldInfo currentField = ready_fields.get(currentProperty);
            if (currentField.autoIncrement()) continue;
            if (currentField.getType().getRealType().equalsIgnoreCase("int") || currentField.getType() == FieldType.TEXT || currentField.getType() == FieldType.BIT || currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                parameters.append("@").append(currentField.getName()).append(" ").append(currentField.get("type")).append(dot);
                if (currentField.getType() == FieldType.TEXT) {
                    values.append("'").append(currentField.stringValue().replaceAll("'", "''")).append("'").append(dot);
                } else if (currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    values.append("'").append(format.format(currentField.value())).append("'").append(dot);
                } else if (currentField.getType() == FieldType.BIT) {
                    if (currentField.value() != null) {
                        values.append(currentField.value().toString().equals("true") ? 1 : 0).append(dot);
                    } else {
                        values.append("0").append(dot);
                    }
                } else {
                    values.append(currentField.value()).append(dot);
                }
            } else {
                parameters.append("@").append(currentField.getName()).append(" ").append(currentField.get("type")).append("(").append(currentField.getLength()).append(")").append(dot);
                values.append("'").append(currentField.stringValue().replaceAll("'", "''")).append("'").append(dot);
            }
            dataKeys.append(currentField.getColumnName()).append(dot);
            keys.append("@").append(currentField.getName()).append(dot);
        }
        dataKeys = new StringBuilder(dataKeys.substring(0, dataKeys.length() - 1));
        keys = new StringBuilder(keys.substring(0, keys.length() - 1));
        values = new StringBuilder(values.substring(0, values.length() - 1));
        parameters = new StringBuilder(parameters.substring(0, parameters.length() - 1));
        table = table.replaceAll("\\[", "").replaceAll("\\]", "");
        SQL = "if not exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[" + table + "_APPEND]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)";
        SQL = (String)SQL + "BEGIN exec('CREATE PROCEDURE [dbo].[" + table + "_APPEND] " + parameters + " AS INSERT INTO [" + table + "](" + dataKeys + ") VALUES(" + keys + ")')";
        SQL = (String)SQL + " {call " + table + "_APPEND(" + values + ")} END";
        SQL = (String)SQL + " else {call " + table + "_APPEND(" + values + ")}";
        try (DatabaseOperator operator = new DatabaseOperator();){
            operator.createStatement(false);
            if (operator.update((String)SQL) > 0) {
                inserted = true;
            }
        }
        return inserted;
    }

    @Override
    public boolean delete(Object Id2, String table) throws ApplicationException {
        boolean deleted = false;
        String SQL = "DELETE FROM [" + table + "] WHERE id=?";
        try (DatabaseOperator operator = new DatabaseOperator();){
            PreparedStatement ps = operator.preparedStatement(SQL, new Object[0]);
            ps.setObject(1, Id2);
            if (operator.update() > 0) {
                deleted = true;
            }
        }
        catch (SQLException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return deleted;
    }

    @Override
    public boolean update(Field ready_fields, String table) throws ApplicationException {
        StringBuilder parameters = new StringBuilder();
        StringBuilder values = new StringBuilder();
        StringBuilder expressions = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        StringBuilder keys = new StringBuilder();
        String dot = ",";
        boolean edited = false;
        Enumeration _field = ready_fields.keys();
        while (_field.hasMoreElements()) {
            String currentProperty = (String)_field.nextElement();
            FieldInfo currentField = ready_fields.get(currentProperty);
            if (currentField.autoIncrement()) {
                parameters.append("@").append(currentField.getName()).append(" ").append(currentField.get("type")).append(",");
                values.append(currentField.value()).append(",");
                continue;
            }
            if (currentField.getType().getRealType().equalsIgnoreCase("int") || currentField.getType() == FieldType.TEXT || currentField.getType() == FieldType.BIT || currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                parameters.append("@").append(currentField.getName()).append(" ").append(currentField.get("type")).append(",");
                if (currentField.getType() == FieldType.TEXT) {
                    values.append("'").append(currentField.stringValue().replaceAll("'", "''")).append("'").append(",");
                } else if (currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    values.append("'").append(format.format(currentField.value())).append("'").append(",");
                } else if (currentField.getType() == FieldType.BIT) {
                    values.append(currentField.value().toString().equals("true") ? 1 : 0).append(",");
                } else {
                    values.append(currentField.value()).append(",");
                }
            } else {
                parameters.append("@").append(currentField.getName()).append(" ").append(currentField.get("type")).append("(").append(currentField.getLength()).append(")").append(",");
                values.append("'").append(currentField.stringValue().replaceAll("'", "''")).append("'").append(",");
            }
            keys.append("@").append(currentField.getName());
            expressions.append("[").append(currentField.getColumnName()).append("]=").append((CharSequence)keys).append(",");
        }
        values.setLength(values.length() - 1);
        expressions.setLength(expressions.length() - 1);
        parameters.setLength(parameters.length() - 1);
        table = table.replaceAll("\\[", "").replaceAll("\\]", "");
        sql.append("if not exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[").append(table).append("_EDIT]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)");
        sql.append("BEGIN exec('CREATE PROCEDURE [dbo].[").append(table).append("_EDIT] ").append((CharSequence)parameters).append(" AS UPDATE [").append(table).append("] SET ").append((CharSequence)expressions).append(" WHERE id=@Id')");
        sql.append(" {call ").append(table).append("_EDIT(").append((CharSequence)values).append(")} END");
        sql.append(" else {call ").append(table).append("_EDIT(").append((CharSequence)values).append(")}");
        try (DatabaseOperator operator = new DatabaseOperator();){
            operator.createStatement(false);
            if (operator.update(sql.toString()) > 0) {
                edited = true;
            }
        }
        return edited;
    }

    @Override
    public Repository.Type getType() {
        return Repository.Type.SQLServer;
    }

    @Override
    public Table find(String SQL, Object[] parameters) throws ApplicationException {
        Table table = new Table();
        try (DatabaseOperator operator = new DatabaseOperator();){
            operator.preparedStatement(SQL, parameters);
            operator.query();
            int cols = operator.getResultSet().getMetaData().getColumnCount();
            String[] fieldName = new String[cols];
            Object[] fieldValue = new Object[cols];
            for (int i = 0; i < cols; ++i) {
                fieldName[i] = operator.getResultSet().getMetaData().getColumnName(i + 1);
            }
            while (operator.getResultSet().next()) {
                Row row = new Row();
                Field fields = new Field();
                for (int i = 0; i < fieldName.length; ++i) {
                    Object v_field = operator.getResultSet().getObject(i + 1);
                    fieldValue[i] = v_field == null ? "" : v_field;
                    FieldInfo field = new FieldInfo();
                    field.append("name", fieldName[i]);
                    field.append("value", fieldValue[i]);
                    field.append("type", field.typeOf(v_field).getTypeName());
                    fields.append(field.getName(), field);
                }
                row.append(fields);
                table.append(row);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return table;
    }

    @Override
    public Row findOne(String SQL, Object[] parameters) throws ApplicationException {
        Row row = new Row();
        Field field = new Field();
        try (DatabaseOperator operator = new DatabaseOperator();){
            operator.preparedStatement(SQL, parameters);
            operator.query();
            int cols = operator.getResultSet().getMetaData().getColumnCount();
            String[] fieldName = new String[cols];
            Object[] fieldValue = new Object[cols];
            for (int i = 0; i < cols; ++i) {
                fieldName[i] = operator.getResultSet().getMetaData().getColumnName(i + 1);
            }
            if (operator.getResultSet().next()) {
                for (int i = 0; i < fieldName.length; ++i) {
                    Object v_field = operator.getResultSet().getObject(i + 1);
                    fieldValue[i] = v_field == null ? "" : v_field;
                    FieldInfo fieldInfo = new FieldInfo();
                    fieldInfo.append("name", fieldName[i]);
                    fieldInfo.append("value", fieldValue[i]);
                    fieldInfo.append("type", fieldInfo.typeOf(v_field));
                    field.append(fieldInfo.getName(), fieldInfo);
                }
                row.append(field);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return row;
    }
}

