/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.data.Repository;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.data.component.FieldType;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.Table;

public class SQLiteServer
implements Repository {
    @Override
    public boolean append(Field ready_fields, String table) throws ApplicationException {
        FieldInfo currentField;
        boolean inserted = false;
        String dot = ",";
        StringBuilder expressions = new StringBuilder();
        StringBuilder values = new StringBuilder();
        ArrayList<String> fieldNames = new ArrayList<String>();
        Enumeration _field = ready_fields.keys();
        while (_field.hasMoreElements()) {
            String currentProperty = (String)_field.nextElement();
            currentField = ready_fields.get(currentProperty);
            if (currentField.autoIncrement()) continue;
            fieldNames.add(currentProperty);
            if (expressions.length() == 0) {
                expressions.append("`").append(currentField.getColumnName()).append("`");
            } else {
                expressions.append(dot).append("`").append(currentField.getColumnName()).append("`");
            }
            if (values.length() == 0) {
                values.append('?');
                continue;
            }
            values.append(dot).append('?');
        }
        String SQL = "INSERT INTO " + table + " (" + expressions + ") VALUES(" + values + ")";
        Iterator iterator = fieldNames.iterator();
        try (DatabaseOperator operator = new DatabaseOperator();){
            PreparedStatement ps = operator.preparedStatement(SQL, new Object[0]);
            int i = 1;
            while (iterator.hasNext()) {
                currentField = ready_fields.get((String)iterator.next());
                if (currentField.autoIncrement()) continue;
                if (currentField.getType().getRealType().equalsIgnoreCase("int")) {
                    ps.setInt(i++, currentField.intValue());
                    continue;
                }
                if (currentField.getType() == FieldType.TEXT) {
                    ps.setString(i++, currentField.stringValue());
                    continue;
                }
                if (currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                    ps.setTimestamp(i++, new Timestamp(currentField.dateValue().getTime()));
                    continue;
                }
                if (currentField.getType() == FieldType.BIT) {
                    ps.setBoolean(i++, currentField.booleanValue());
                    continue;
                }
                ps.setObject(i++, currentField.value());
            }
            if (operator.update() > 0) {
                inserted = true;
            }
        }
        catch (SQLException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return inserted;
    }

    @Override
    public boolean update(Field ready_fields, String table) throws ApplicationException {
        FieldInfo currentField;
        String dot = ",";
        StringBuilder expressions = new StringBuilder();
        Object Id2 = null;
        boolean edited = false;
        ArrayList<String> fieldNames = new ArrayList<String>();
        Enumeration _field = ready_fields.keys();
        while (_field.hasMoreElements()) {
            String currentProperty = (String)_field.nextElement();
            currentField = ready_fields.get(currentProperty);
            if (currentField.getName().equalsIgnoreCase("Id")) {
                Id2 = currentField.value();
                continue;
            }
            if (currentField.value() == null) continue;
            fieldNames.add(currentProperty);
            if (expressions.length() == 0) {
                expressions.append("`").append(currentField.getColumnName()).append("`").append("=?");
                continue;
            }
            expressions.append(dot).append("`").append(currentField.getColumnName()).append("`").append("=?");
        }
        String SQL = "UPDATE " + table + " SET " + expressions + " WHERE id=?";
        Iterator iterator = fieldNames.iterator();
        try (DatabaseOperator operator = new DatabaseOperator();){
            PreparedStatement ps = operator.preparedStatement(SQL, new Object[0]);
            int i = 1;
            while (iterator.hasNext()) {
                currentField = ready_fields.get((String)iterator.next());
                if (currentField.getType().getRealType().equalsIgnoreCase("int")) {
                    ps.setInt(i++, currentField.intValue());
                    continue;
                }
                if (currentField.getType() == FieldType.TEXT) {
                    ps.setString(i++, currentField.stringValue());
                    continue;
                }
                if (currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                    ps.setTimestamp(i++, new Timestamp(currentField.dateValue().getTime()));
                    continue;
                }
                if (currentField.getType() == FieldType.BIT) {
                    ps.setBoolean(i++, currentField.booleanValue());
                    continue;
                }
                ps.setObject(i++, currentField.value());
            }
            ps.setObject(i, Id2);
            if (operator.update() > 0) {
                edited = true;
            }
        }
        catch (SQLException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return edited;
    }

    @Override
    public boolean delete(Object Id2, String table) throws ApplicationException {
        boolean deleted = false;
        String SQL = "DELETE FROM " + table + " WHERE id=?";
        try (DatabaseOperator operator = new DatabaseOperator();){
            PreparedStatement ps = operator.preparedStatement(SQL, new Object[0]);
            ps.setObject(1, Id2);
            if (operator.update() > 0) {
                deleted = true;
            }
        }
        catch (SQLException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return deleted;
    }

    @Override
    public Repository.Type getType() {
        return Repository.Type.SQLite;
    }

    @Override
    public Table find(String SQL, Object[] parameters) throws ApplicationException {
        Table table = new Table();
        try (DatabaseOperator operator = new DatabaseOperator();){
            operator.preparedStatement(SQL, parameters);
            operator.query();
            int cols = operator.getResultSet().getMetaData().getColumnCount();
            String[] fieldName = new String[cols];
            Object[] fieldValue = new Object[cols];
            for (int i = 0; i < cols; ++i) {
                fieldName[i] = operator.getResultSet().getMetaData().getColumnName(i + 1);
            }
            while (operator.getResultSet().next()) {
                Row row = new Row();
                Field fields = new Field();
                for (int i = 0; i < fieldName.length; ++i) {
                    Object v_field = operator.getResultSet().getObject(i + 1);
                    fieldValue[i] = v_field == null ? "" : v_field;
                    FieldInfo field = new FieldInfo();
                    field.append("name", fieldName[i]);
                    field.append("value", fieldValue[i]);
                    field.append("type", field.typeOf(v_field).getTypeName());
                    fields.append(field.getName(), field);
                }
                row.append(fields);
                table.append(row);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return table;
    }

    @Override
    public Row findOne(String SQL, Object[] parameters) throws ApplicationException {
        Row row = new Row();
        Field field = new Field();
        try (DatabaseOperator operator = new DatabaseOperator();){
            operator.preparedStatement(SQL, parameters);
            operator.query();
            int cols = operator.getResultSet().getMetaData().getColumnCount();
            String[] fieldName = new String[cols];
            Object[] fieldValue = new Object[cols];
            for (int i = 0; i < cols; ++i) {
                fieldName[i] = operator.getResultSet().getMetaData().getColumnName(i + 1);
            }
            if (operator.getResultSet().next()) {
                for (int i = 0; i < fieldName.length; ++i) {
                    Object v_field = operator.getResultSet().getObject(i + 1);
                    fieldValue[i] = v_field == null ? "" : v_field;
                    FieldInfo fieldInfo = new FieldInfo();
                    fieldInfo.append("name", fieldName[i]);
                    fieldInfo.append("value", fieldValue[i]);
                    fieldInfo.append("type", fieldInfo.typeOf(v_field));
                    field.append(fieldInfo.getName(), fieldInfo);
                }
                row.append(field);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return row;
    }
}

