/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.tools;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.tinystruct.AbstractApplication;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.tools.MessageQueue;

public class KafkaClient
extends AbstractApplication
implements MessageQueue<ProducerRecord> {
    private final KafkaProducer<String, String> producer;

    public KafkaClient() {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", "192.168.1.101:9092");
        properties.put("ack", "all");
        properties.put("key.serializer", StringSerializer.class.getName());
        properties.put("value.serializer", StringSerializer.class.getName());
        this.producer = new KafkaProducer(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ProducerRecord record) {
        Future future = this.producer.send(record);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            this.producer.close();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void init() {
        this.setAction("send", "send");
    }

    @Override
    public String version() {
        return null;
    }

    public static void main(String[] args) throws ApplicationException {
        System.out.println(StringSerializer.class.getName());
    }
}

