/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.data.component.FieldType;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.Table;
import org.tinystruct.data.tools.Generator;
import org.tinystruct.data.tools.MSSQLGenerator;
import org.tinystruct.dom.Document;
import org.tinystruct.dom.Element;
import org.tinystruct.system.util.FileGenerator;
import org.tinystruct.system.util.StringUtilities;

public class MySQLGenerator
implements Generator {
    private String fileName = "src/main/java/org/tinystruct/customer/object/";
    private String packageName;
    private static final Logger logger = Logger.getLogger(MSSQLGenerator.class.getName());
    private String[] packageList = new String[0];

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void create(String className, String table) throws ApplicationException {
        StringBuilder java_resource = new StringBuilder();
        StringBuilder java_member_declaration = new StringBuilder();
        StringBuilder java_method_declaration = new StringBuilder();
        StringBuilder java_method_setdata = new StringBuilder();
        StringBuilder java_method_tostring = new StringBuilder();
        String spliter = "";
        this.fileName = this.fileName.endsWith("/") ? this.fileName + className : this.fileName + File.separator + className;
        if (this.packageName != null) {
            java_resource.append("package ").append(this.packageName).append(";\r\n");
        } else {
            java_resource.append("package org.tinystruct.customer.object;\r\n");
        }
        java_resource.append("import java.io.Serializable;\r\n");
        if (this.packageList.length > 0) {
            java_resource.append("\r\n");
            for (int i = 0; i < this.packageList.length; ++i) {
                java_resource.append("import ").append(this.packageList[i]).append(";\r\n");
            }
        }
        java_resource.append("\r\n");
        java_resource.append("import org.tinystruct.data.component.Row;\r\n");
        java_resource.append("import org.tinystruct.data.component.AbstractData;\r\n\r\n");
        java_resource.append("public class ").append(className).append(" extends AbstractData implements Serializable {\r\n");
        java_resource.append("\t/**\r\n");
        java_resource.append("   * Auto Generated Serial Version UID\r\n");
        java_resource.append("   */\r\n");
        java_resource.append("  private static final long serialVersionUID = ").append(new SecureRandom().nextLong()).append("L;\r\n");
        Element rootElement = new Element("mapping");
        Element classElement = rootElement.addElement("class");
        classElement.setAttribute("name", className);
        classElement.setAttribute("table", table);
        String command = "desc `" + table + "`";
        Table data = this.find(command);
        for (Row currentRow : data) {
            Iterator fields = currentRow.iterator();
            System.out.println(currentRow);
            while (fields.hasNext()) {
                Field currentFields = (Field)fields.next();
                System.out.println(currentFields);
                String propertyName = StringUtilities.setCharToUpper(currentFields.get("COLUMN_NAME").value().toString(), '_');
                propertyName = StringUtilities.remove(propertyName, '_');
                String propertyNameOfMethod = StringUtilities.setCharToUpper(propertyName, 0);
                String propertyTypeValue = currentFields.get("COLUMN_TYPE").value().toString();
                String[] props = propertyTypeValue.split("\\(");
                String propertyType = FieldType.valueOf(props[0]).getRealType();
                if (java_method_tostring.length() > 0) {
                    spliter = ",";
                }
                if (currentFields.get("COLUMN_NAME").value().equals("id")) {
                    boolean increment;
                    boolean bl = increment = currentFields.get("EXTRA").stringValue().indexOf("auto_increment") != -1;
                    if (propertyType.equalsIgnoreCase("String")) {
                        java_method_tostring.append("\t\tbuffer.append(\"").append(spliter).append("\\\"").append(propertyNameOfMethod).append("\\\":\\\"\"+this.get").append(propertyNameOfMethod).append("()+\"\\\"\");\r\n");
                    } else {
                        java_method_tostring.append("\t\tbuffer.append(\"").append(spliter).append("\\\"").append(propertyNameOfMethod).append("\\\":\"+this.get").append(propertyNameOfMethod).append("());\r\n");
                    }
                    Element idElement = classElement.addElement("id");
                    idElement.setAttribute("name", propertyNameOfMethod);
                    idElement.setAttribute("column", currentFields.get("COLUMN_NAME").value().toString());
                    idElement.setAttribute("increment", String.valueOf(increment));
                    idElement.setAttribute("generate", String.valueOf(!increment));
                    idElement.setAttribute("length", props.length > 1 ? props[1].split("\\)")[0] : "0");
                    idElement.setAttribute("type", props[0]);
                    if (propertyType.equalsIgnoreCase("String")) {
                        java_method_declaration.append("\tpublic ").append(propertyType).append(" get").append(propertyNameOfMethod).append("()\r\n");
                        java_method_declaration.append("\t{\r\n");
                        java_method_declaration.append("\t\treturn String.valueOf(this.").append(propertyNameOfMethod).append(");\r\n");
                    } else if (propertyType.equalsIgnoreCase("int")) {
                        java_method_declaration.append("\tpublic Integer get").append(propertyNameOfMethod).append("()\r\n");
                        java_method_declaration.append("\t{\r\n");
                        java_method_declaration.append("\t\treturn Integer.parseInt(this.").append(propertyNameOfMethod).append(".toString());\r\n");
                    }
                    java_method_declaration.append("\t}\r\n\r\n");
                } else {
                    java_member_declaration.append("\tprivate ").append(propertyType).append(" ").append(propertyName).append(";\r\n");
                    java_method_declaration.append("\tpublic void set").append(propertyNameOfMethod).append("(").append(propertyType).append(" ").append(propertyName).append(")\r\n");
                    java_method_declaration.append("\t{\r\n");
                    java_method_declaration.append("\t\tthis.").append(propertyName).append(" = this.setFieldAs").append(StringUtilities.setCharToUpper(propertyType, 0)).append("(\"").append(propertyName).append("\",").append(propertyName).append(");\r\n");
                    java_method_declaration.append("\t}\r\n\r\n");
                    if (propertyType.equalsIgnoreCase("String") || propertyType.equalsIgnoreCase("Date")) {
                        java_method_tostring.append("\t\tbuffer.append(\"").append(spliter).append("\\\"").append(propertyName).append("\\\":\\\"\"+this.get").append(propertyNameOfMethod).append("()+\"\\\"\");\r\n");
                    } else {
                        java_method_tostring.append("\t\tbuffer.append(\"").append(spliter).append("\\\"").append(propertyName).append("\\\":\"+this.get").append(propertyNameOfMethod).append("());\r\n");
                    }
                    Element propertyElement = classElement.addElement("property");
                    propertyElement.setAttribute("name", propertyName);
                    propertyElement.setAttribute("column", currentFields.get("COLUMN_NAME").value().toString());
                    propertyElement.setAttribute("length", props.length > 1 ? props[1].split("\\)")[0] : "0");
                    propertyElement.setAttribute("type", props[0]);
                    java_method_declaration.append("\tpublic ").append(propertyType).append(" get").append(propertyNameOfMethod).append("()\r\n");
                    java_method_declaration.append("\t{\r\n");
                    java_method_declaration.append("\t\treturn this.").append(propertyName).append(";\r\n");
                    java_method_declaration.append("\t}\r\n\r\n");
                }
                java_method_setdata.append("\t\tif(row.getFieldInfo(\"").append(currentFields.get("COLUMN_NAME").value().toString()).append("\")!=null)");
                java_method_setdata.append("\tthis.set").append(propertyNameOfMethod).append("(row.getFieldInfo(\"").append(currentFields.get("COLUMN_NAME").value().toString()).append("\").").append(StringUtilities.setCharToLower(propertyType, 0)).append("Value());\r\n");
            }
        }
        Document Document2 = new Document(rootElement);
        try {
            Document2.save(new FileOutputStream(this.fileName.replace("main" + File.separator + "java", "main" + File.separator + "resources") + ".map.xml"));
        }
        catch (IOException IO) {
            logger.severe(IO.getMessage());
        }
        java_resource.append((CharSequence)java_member_declaration);
        java_resource.append("\r\n");
        java_resource.append((CharSequence)java_method_declaration);
        java_resource.append("\r\n");
        java_resource.append("\t@Override\r\n");
        java_resource.append("\tpublic void setData(Row row) {\r\n");
        java_resource.append((CharSequence)java_method_setdata);
        java_resource.append("\t}\r\n\r\n");
        java_resource.append("\t@Override\r\n");
        java_resource.append("\tpublic String toString() {\r\n");
        java_resource.append("\t\tStringBuilder buffer = new StringBuilder();\r\n");
        java_resource.append("\t\tbuffer.append(\"{\");\r\n");
        java_resource.append((CharSequence)java_method_tostring);
        java_resource.append("\t\tbuffer.append(\"}\");\r\n");
        java_resource.append("\t\treturn buffer.toString();\r\n");
        java_resource.append("\t}\r\n\r\n");
        java_resource.append("}");
        FileGenerator generator = new FileGenerator(this.fileName + ".java", java_resource);
        generator.save();
    }

    public Table find(String SQL) throws ApplicationException {
        logger.severe("find:" + SQL);
        Table table = new Table();
        try (DatabaseOperator Operator = new DatabaseOperator();){
            Operator.createStatement(false);
            Operator.query(SQL);
            int cols = Operator.getResultSet().getMetaData().getColumnCount();
            String[] fieldName = new String[cols];
            String[] fieldValue = new String[cols];
            for (int i = 0; i < cols; ++i) {
                fieldName[i] = Operator.getResultSet().getMetaData().getColumnName(i + 1);
            }
            while (Operator.getResultSet().next()) {
                Row row = new Row();
                Field fields = new Field();
                for (int i = 0; i < fieldName.length; ++i) {
                    Object v_field = Operator.getResultSet().getObject(i + 1);
                    fieldValue[i] = v_field == null ? "" : v_field.toString();
                    FieldInfo field = new FieldInfo();
                    field.append("name", fieldName[i]);
                    field.append("value", fieldValue[i]);
                    field.append("type", field.typeOf(v_field).getTypeName());
                    fields.append(field.getName(), field);
                }
                row.append(fields);
                table.append(row);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return table;
    }

    @Override
    public void importPackages(String packageNameList) {
        this.packageList = packageNameList.split(";");
    }
}

