/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.dom;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.tinystruct.ApplicationException;
import org.tinystruct.dom.Element;
import org.tinystruct.system.Resources;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Document
extends DefaultHandler {
    private static final Logger LOG = Logger.getLogger(Document.class.getName());
    private static final String DOCTYPE_CONFIGURATION = "org/tinystruct/application/application-1.0.dtd";
    private static final String XHTML_TRANSITIONAL_DOCTYPE_CONFIGURATION = "org/tinystruct/application/application-1.0.dtd";
    private static final String XHTML_STRICT_DOCTYPE_CONFIGURATION = "org/tinystruct/application/application-1.0.dtd";
    private static final Map<String, String> doctypeMap = new HashMap<String, String>();
    private Element rootElement;
    private Element currentElement;
    private final CharArrayWriter contents = new CharArrayWriter();
    private URL url = null;

    public Document(URL url) {
        this.url = url;
    }

    public Document() {
        this.currentElement = null;
        this.rootElement = null;
    }

    public Document(Element element) {
        this.rootElement = element;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public boolean load() {
        return this.load(this.url);
    }

    public boolean load(String file) throws ApplicationException {
        try {
            FileInputStream input = new FileInputStream(file);
            return this.load(input);
        }
        catch (FileNotFoundException FileNotFound) {
            throw new ApplicationException(FileNotFound.getMessage(), FileNotFound);
        }
    }

    public boolean load(InputStream input) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(input, (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
            LOG.severe("XML config error while attempting to read from the input stream \n'" + input + "'");
            LOG.severe(ex.toString());
            ex.printStackTrace();
            return false;
        }
        catch (SAXException ex) {
            LOG.severe("XML parse error while attempting to read from the input stream \n'" + input + "'");
            LOG.severe(ex.toString());
            ex.printStackTrace();
            return false;
        }
        catch (IOException ex) {
            LOG.severe("I/O error while attempting to read from the input stream \n'" + input + "'");
            LOG.severe(ex.toString());
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean load(URL inputURL) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(inputURL.toString(), (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
            LOG.severe("XML config error while attempting to read XML file \n'" + inputURL + "'");
            LOG.severe(ex.toString());
            ex.printStackTrace();
            return false;
        }
        catch (SAXException ex) {
            LOG.severe("XML parse error while attempting to read XML file \n'" + inputURL + "'");
            LOG.severe(ex.toString());
            ex.printStackTrace();
            return false;
        }
        catch (IOException ex) {
            LOG.severe("I/O error while attempting to read XML file \n'" + inputURL + "'");
            LOG.severe(ex.toString());
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean read(String text) throws ApplicationException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)new ByteArrayInputStream(text.getBytes()), (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
            LOG.severe("XML config ParserConfigurationException error while attempting to read XML text");
            LOG.severe(ex.toString());
            throw new ApplicationException(ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            LOG.severe("XML config SAXException error while attempting to read XML text");
            LOG.severe(ex.toString());
            throw new ApplicationException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            LOG.severe("XML config IOException error while attempting to read XML text");
            LOG.severe(ex.toString());
            throw new ApplicationException(ex.getMessage(), ex);
        }
        return true;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            this.contents.reset();
            String name = localName;
            if (name.equals("")) {
                name = qName;
            }
            this.currentElement = this.rootElement == null ? (this.rootElement = new Element(name)) : this.currentElement.addElement(name);
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if (aName.equals("")) {
                        aName = attrs.getQName(i);
                    }
                    this.currentElement.setAttribute(aName, attrs.getValue(i));
                }
            }
        }
        catch (NullPointerException ex) {
            LOG.severe("Null!!!");
            LOG.severe(ex.toString());
            ex.printStackTrace();
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.currentElement != null) {
            this.currentElement.setData(this.contents.toString().trim());
            this.contents.reset();
            this.currentElement = this.currentElement.getParent();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    public Element getRoot() {
        return this.rootElement;
    }

    public void save() throws Exception {
        this.save(new FileOutputStream(this.url.getPath()));
    }

    public void save(OutputStream out) throws IOException {
        BufferedWriter PW = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        PW.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (this.rootElement.getChildNodes().size() > 0) {
            PW.write(this.rootElement.toString());
        }
        PW.flush();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        InputSource source = null;
        try {
            String path = doctypeMap.get(publicId);
            source = this.getInputSource(path, source);
            if (source != null) {
                path = doctypeMap.get(systemId);
                source = this.getInputSource(path, source);
            }
        }
        catch (Exception e) {
            throw new SAXException(e.toString());
        }
        return source;
    }

    private InputSource getInputSource(String path, InputSource source) {
        if (path != null) {
            InputStream in = null;
            try {
                in = Resources.getResourceAsStream(path);
                source = new InputSource(in);
            }
            catch (IOException e) {
                LOG.severe(e.toString());
                e.printStackTrace();
            }
        }
        return source;
    }

    static {
        doctypeMap.put("-//development.tinystruct.org//DTD APPLICATION Configuration 2.0//EN", "org/tinystruct/application/application-1.0.dtd");
        doctypeMap.put("http://development.tinystruct.org/dtd/application-1.0.dtd", "org/tinystruct/application/application-1.0.dtd");
        doctypeMap.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "org/tinystruct/application/application-1.0.dtd");
        doctypeMap.put("-//W3C//DTD XHTML 1.0 Strict//EN", "org/tinystruct/application/application-1.0.dtd");
    }
}

