/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.dom;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.tinystruct.dom.Attribute;
import org.tinystruct.dom.ElementType;

public class Element
implements Cloneable {
    private String name;
    private String data;
    private ElementType elementType = ElementType.NORMAL;
    private List<Attribute> attributes;
    private List<Element> childNodes;
    private Element parent;
    private boolean haveData = false;
    public int level = 0;

    public Element() {
        this.name = "";
        this.childNodes = new Vector<Element>();
        this.attributes = new Vector<Attribute>();
        this.data = "";
    }

    public Element(String name) {
        this.name = name;
        this.attributes = new Vector<Attribute>();
        this.childNodes = new Vector<Element>();
        this.data = "";
    }

    public Element(String name, List<Attribute> attributes) {
        this.name = name;
        this.attributes = attributes;
        this.childNodes = new Vector<Element>();
        this.data = "";
    }

    public Element(String name, String data) {
        this.name = name;
        this.attributes = new Vector<Attribute>();
        this.childNodes = new Vector<Element>();
        this.data = data;
    }

    public void setElementType(ElementType type) {
        this.elementType = type;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public Attribute setAttribute(String keyName, Object value) {
        if (value != null && keyName != null) {
            boolean exists = false;
            for (Attribute attribute : this.attributes) {
                if (!attribute.name.equalsIgnoreCase(keyName)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                Attribute returnValue = new Attribute(keyName, String.valueOf(value));
                this.attributes.add(returnValue);
                return returnValue;
            }
        }
        return null;
    }

    public String getAttribute(String attributeName) {
        for (Attribute attribute : this.attributes) {
            if (!attribute.name.equalsIgnoreCase(attributeName)) continue;
            return attribute.value;
        }
        return "";
    }

    public void removeAttribute(String attributeName) {
        for (Attribute attribute : this.attributes) {
            if (!attribute.name.equalsIgnoreCase(attributeName)) continue;
            this.attributes.remove(attribute);
            break;
        }
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public Vector<String> getAttributeNames() {
        int i = 0;
        int size = this.attributes.size();
        Vector<String> keys = new Vector<String>(size);
        while (i < size) {
            keys.add(this.attributes.get((int)i++).name);
        }
        return keys;
    }

    public boolean addElement(Element element) {
        element.setParent(this);
        element.level = this.level + 1;
        return this.childNodes.add(element);
    }

    public Element addElement(String elementName) {
        Element element = new Element(elementName);
        if (this.addElement(element)) {
            return element;
        }
        return null;
    }

    public boolean removeElement(Element element) {
        return this.childNodes.remove(element);
    }

    public boolean removeElement(String elementName) {
        int i = 0;
        Element the_target_element = null;
        while (i < this.childNodes.size()) {
            the_target_element = this.childNodes.get(i);
            if (!the_target_element.name.equalsIgnoreCase(elementName)) continue;
            break;
        }
        return this.childNodes.remove(the_target_element);
    }

    public Element removeElement(int index) {
        return this.childNodes.remove(index);
    }

    public void removeAllElements() {
        this.childNodes = new Vector<Element>();
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeElement(this);
            this.parent = null;
        }
    }

    public boolean contains(Element element) {
        return this.childNodes.contains(element);
    }

    public void append(Element element) {
        if (this.parent != null && this.parent.contains(element)) {
            this.parent.removeElement(element);
        }
        this.addElement(element);
    }

    public void insertElement(Element e, int index) {
        e.removeFromParent();
        this.childNodes.add(index, e);
        e.setParent(this);
    }

    public List<Element> getChildNodes() {
        return this.childNodes;
    }

    public int size() {
        return this.childNodes.size();
    }

    public Vector<String> getElementsTagNames() {
        Vector<String> keys = new Vector<String>(this.size());
        int i = 0;
        while (i < this.size()) {
            keys.add(this.getElementByIndex((int)i++).name);
        }
        return keys;
    }

    public Element getElementByIndex(int index) {
        return this.childNodes.get(index);
    }

    private boolean containsAttribute(List<Attribute> attributes, String attributeName) {
        int i = 0;
        int size = attributes.size();
        while (i < size) {
            if (!this.attributes.get((int)i++).name.equalsIgnoreCase(attributeName)) continue;
            return true;
        }
        return false;
    }

    private String getAttribute(List<Attribute> attributes, String attributeName) {
        for (Attribute attribute : attributes) {
            if (!attribute.name.equalsIgnoreCase(attributeName)) continue;
            return attribute.value;
        }
        return "";
    }

    public Element getElementById(String Id2) {
        int i = 0;
        Element currentElement = null;
        while (i < this.childNodes.size()) {
            if (this.containsAttribute(this.childNodes.get((int)i).attributes, "id")) {
                if (this.getAttribute(this.childNodes.get((int)i).attributes, "id").equalsIgnoreCase(Id2)) {
                    currentElement = this.childNodes.get(i);
                    break;
                }
                currentElement = this.childNodes.get(i++).getElementById(Id2);
                continue;
            }
            currentElement = this.childNodes.get(i++).getElementById(Id2);
        }
        return currentElement;
    }

    private List<Element> getChildElementsByTagName(String tagName) {
        Vector<Element> foundElementList = new Vector<Element>();
        for (Element currentElement : this.childNodes) {
            currentElement.getChildElementsByTagName(tagName);
            if (!currentElement.name.equalsIgnoreCase(tagName)) continue;
            foundElementList.add(currentElement);
        }
        return foundElementList;
    }

    public List<Element> getElementsByTagName(String tagName) {
        return this.getChildElementsByTagName(tagName);
    }

    public void setParent(Element parent) {
        this.parent = parent;
    }

    public Element getParent() {
        return this.parent;
    }

    public Element setData(String data) {
        this.data = data;
        this.haveData = true;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public String getSpace() {
        StringBuffer space = new StringBuffer();
        int n = this.level;
        while (n-- > 0) {
            space.append(" ");
        }
        if (space.length() == 0) {
            return space + "\r\n";
        }
        return "\r\n" + space;
    }

    public String toString() {
        boolean valid;
        if (this.elementType == ElementType.TEXT) {
            return this.name;
        }
        boolean bl = valid = this.name != null && this.name.trim().length() != 0;
        if (!valid) {
            return "Invalid Tag Name";
        }
        StringBuffer buffer = new StringBuffer();
        StringBuffer nodes = new StringBuffer();
        buffer.append(this.getSpace());
        buffer.append("<");
        buffer.append(this.name);
        for (Attribute currentAttribute : this.attributes) {
            buffer.append(" " + currentAttribute.name + "=\"" + currentAttribute.value + "\"");
        }
        if (this.data != null) {
            nodes.append(this.data);
        }
        if (this.childNodes.size() > 0) {
            Iterator<Element> childList = this.childNodes.iterator();
            while (childList.hasNext()) {
                nodes.append(childList.next().toString());
            }
            nodes.append(this.getSpace());
        }
        if (this.haveData || nodes.length() > 0) {
            buffer.append(">");
            buffer.append(nodes);
            buffer.append("</");
            buffer.append(this.name);
            buffer.append(">");
            nodes.delete(0, nodes.length());
        } else {
            buffer.append("/>");
        }
        String s = buffer.toString();
        buffer.delete(0, buffer.length());
        return s;
    }

    public static void printNode(Element node, String indent) {
        String data = node.getData();
        if (data == null || data.equals("")) {
            System.out.println(indent + node.getName());
        } else {
            System.out.println(indent + node.getName() + " = '" + data + "'");
        }
        List<Attribute> attributes = node.getAttributes();
        for (Attribute attribute : attributes) {
            System.out.println(indent + attribute.name + ":" + attribute.value);
        }
        List<Element> subs = node.getChildNodes();
        Iterator<Element> it = subs.iterator();
        while (it.hasNext()) {
            Element.printNode(it.next(), indent + "    ");
        }
    }

    public Object clone() {
        try {
            Element clone = (Element)super.clone();
            if (this.attributes != null) {
                clone.attributes = new Vector<Attribute>();
                List<Attribute> attribs = this.attributes;
                for (Attribute attribute : attribs) {
                    clone.setAttribute((Attribute)attribute.clone());
                }
            }
            if (this.data != null) {
                clone.setData(this.data);
            }
            if (this.childNodes != null) {
                clone.childNodes = new Vector<Element>();
                List<Element> childs = this.childNodes;
                for (Element child : childs) {
                    clone.addElement((Element)child.clone());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError("Could not clone Element: " + cnse);
        }
    }

    public Attribute setAttribute(Attribute attribute) {
        return this.setAttribute(attribute.name, attribute.value);
    }

    public void setName(String name) {
        this.name = name;
    }

    private boolean equals(Object obj1, Object obj2) {
        boolean equal = false;
        if (obj1 == null && obj2 == null) {
            equal = true;
        } else if (obj1 != null && obj2 != null) {
            equal = obj1.equals(obj2);
        }
        return equal;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof Element) {
            Element other = (Element)obj;
            if (this.equals(this.attributes, other.attributes) && this.equals(this.data, other.data) && this.equals(this.name, other.name) && this.equals(this.childNodes, other.childNodes)) {
                equal = true;
            }
        }
        return equal;
    }

    public int hashCode() {
        int hashCode = 23;
        if (this.attributes != null) {
            hashCode += this.attributes.hashCode() * 13;
        }
        if (this.data != null) {
            hashCode += this.data.hashCode() * 17;
        }
        if (this.name != null) {
            hashCode += this.name.hashCode() * 29;
        }
        if (this.childNodes != null) {
            hashCode += this.childNodes.hashCode() * 57;
        }
        return hashCode;
    }
}

