/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.dom;

import java.util.Vector;
import org.tinystruct.ApplicationException;
import org.tinystruct.dom.Attribute;
import org.tinystruct.dom.ElementType;
import org.tinystruct.dom.HTMLElement;
import org.tinystruct.system.util.TextFileLoader;

public class HTMLParser {
    private String HTML;
    private final Vector<HTMLElement> resources = new Vector();
    private int position = 0;
    private int length = 0;
    private int current_position = -1;
    public int last_position = -1;

    public Vector<HTMLElement> getResources() {
        return this.resources;
    }

    public HTMLParser(StringBuffer HTML) {
        this.HTML = HTML.toString();
        this.length = this.HTML.length();
    }

    public HTMLParser(String FileName) throws ApplicationException {
        this.HTML = new TextFileLoader(FileName).getContent().toString();
        this.length = this.HTML.length();
    }

    public int getPositionForStartTag(String text) {
        return this.getPositionForChar(text, '<');
    }

    public int getPositionForEndTag(String text) {
        return this.getPositionForChar(text, '>');
    }

    public int getPositionForChar(String text, char c) {
        if (text.indexOf(c) == -1) {
            return -1;
        }
        char[] _text = text.toCharArray();
        for (int i = this.current_position + 1; i < _text.length; ++i) {
            if (_text[i] != c) continue;
            this.last_position = this.current_position;
            this.position = this.current_position = i;
            return i;
        }
        this.position = -1;
        return -1;
    }

    public String getTagName() {
        String read_content = "";
        return read_content.split(" ")[0];
    }

    public String getTagContent() {
        String current_tag_attributes = "";
        return current_tag_attributes;
    }

    public void process() {
        int beginIndex = 0;
        int endIndex = 0;
        while (this.position < this.length) {
            Attribute attribute;
            String[] attribute_text;
            int i;
            String elementName;
            String[] elementAttribute;
            HTMLElement element;
            beginIndex = this.getPositionForStartTag(this.HTML);
            if (this.position == -1) break;
            String node = this.HTML.substring(endIndex, beginIndex);
            if (node.trim().length() > 0) {
                if (node.indexOf(60) == -1 || node.indexOf(62) == -1) {
                    element = new HTMLElement(node);
                    element.setElementType(ElementType.TEXT);
                } else {
                    elementAttribute = node.split(">")[0].split(" ");
                    elementName = node.split(">")[0].split(" ")[0].replace('<', ' ').trim();
                    element = new HTMLElement(elementName);
                    for (i = 1; i < elementAttribute.length; ++i) {
                        if (elementAttribute[i].indexOf(61) == -1) continue;
                        attribute_text = elementAttribute[i].split("=");
                        attribute = new Attribute(attribute_text[0], attribute_text[1].replace('\"', ' ').trim());
                        element.setAttribute(attribute.name, attribute.value);
                    }
                }
                this.resources.add(element);
            }
            endIndex = this.getPositionForEndTag(this.HTML) + 1;
            if (this.position == -1) break;
            node = this.HTML.substring(beginIndex, endIndex);
            if (node.trim().length() <= 0) continue;
            if (node.indexOf(60) == -1 || node.indexOf(62) == -1) {
                element = new HTMLElement(node);
                element.setElementType(ElementType.TEXT);
            } else {
                elementAttribute = node.split(">")[0].split(" ");
                elementName = node.split(">")[0].split(" ")[0].replace('<', ' ').trim();
                element = new HTMLElement(elementName);
                for (i = 1; i < elementAttribute.length; ++i) {
                    if (elementAttribute[i].indexOf(61) == -1) continue;
                    attribute_text = elementAttribute[i].split("=");
                    attribute = new Attribute(attribute_text[0], attribute_text[1].replace('\"', ' ').trim());
                    element.setAttribute(attribute.name, attribute.value);
                }
            }
            this.resources.add(element);
        }
    }

    public void parse() {
        System.out.println("Parser is starting...");
        this.process();
    }
}

