/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.dom;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.tinystruct.ApplicationException;
import org.tinystruct.dom.XHTML;
import org.tinystruct.system.Resources;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XHTMLEntityResolver
implements EntityResolver {
    private static final Map<String, String> mapping = new HashMap<String, String>();

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (mapping.containsKey(publicId)) {
            try {
                return this.getInputSource(mapping.get(publicId));
            }
            catch (ApplicationException e) {
                System.out.println(e.getMessage());
            }
        }
        return null;
    }

    private InputSource getInputSource(String path) throws ApplicationException {
        InputSource source = null;
        if (path != null) {
            try {
                source = path.startsWith("http://") ? new InputSource(Resources.getUrlAsStream(path)) : new InputSource(Resources.getResourceAsStream(path));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ApplicationException(e.getMessage(), e);
            }
        }
        return source;
    }

    static {
        mapping.put(XHTML.Transitional.PUBLIC, "org/mover/services/application/xhtml1-transitional.dtd");
        mapping.put(XHTML.Strict.PUBLIC, "org/mover/services/application/xhtml1-strict.dtd");
        mapping.put(XHTML.Frameset.PUBLIC, "org/mover/services/application/xhtml1-frameset.dtd");
        mapping.put(XHTML.Latin.PUBLIC, "org/mover/services/application/xhtml-lat1.ent");
        mapping.put(XHTML.Symbols.PUBLIC, "org/mover/services/application/xhtml-symbol.ent");
        mapping.put(XHTML.Special.PUBLIC, "org/mover/services/application/xhtml-special.ent");
    }
}

