/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.handler;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.tinystruct.ApplicationContext;
import org.tinystruct.ApplicationException;
import org.tinystruct.handler.Reforward;
import org.tinystruct.http.ResponseStatus;
import org.tinystruct.http.servlet.RequestBuilder;
import org.tinystruct.http.servlet.ResponseBuilder;
import org.tinystruct.system.ApplicationManager;
import org.tinystruct.system.Bootstrap;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Language;
import org.tinystruct.system.Settings;
import org.tinystruct.system.util.StringUtilities;

public class DefaultHandler
extends HttpServlet
implements Bootstrap,
Filter {
    public static final String HTTP_REQUEST = "HTTP_REQUEST";
    public static final String HTTP_RESPONSE = "HTTP_RESPONSE";
    public static final String HTTP_SCHEME = "HTTP_SCHEME";
    public static final String HTTP_SERVER = "HTTP_SERVER";
    public static final String HTTP_HOST = "HTTP_HOST";
    public static final String METHOD = "METHOD";
    private static final Logger logger = Logger.getLogger(DefaultHandler.class.getName());
    private static final long serialVersionUID = 0L;
    private String charsetName;
    private Configuration<String> settings;
    private String path;

    public void init(ServletConfig config) {
        this.path = config.getServletContext().getRealPath("");
        try {
            this.start();
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        System.out.println("Initialize servlet config and starting...");
    }

    public void init(FilterConfig config) throws ServletException {
        this.path = config.getServletContext().getRealPath("");
        String value = config.getInitParameter("ignore");
        if ("true".equalsIgnoreCase(value)) {
            boolean ignore = true;
        } else {
            boolean ignore = "yes".equalsIgnoreCase(value);
        }
        try {
            this.start();
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        logger.info("Initialize filter config and starting...");
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String hostName;
        request.setCharacterEncoding(this.charsetName);
        response.setContentType("text/html;charset=" + this.charsetName);
        response.setCharacterEncoding(this.charsetName);
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "No-cache");
        response.setDateHeader("Expires", 0L);
        ApplicationContext context = new ApplicationContext();
        RequestBuilder _request = new RequestBuilder(request);
        ResponseBuilder _response = new ResponseBuilder(response);
        context.setAttribute(HTTP_REQUEST, _request);
        context.setAttribute(HTTP_RESPONSE, _response);
        context.setAttribute(HTTP_SCHEME, request.getScheme());
        context.setAttribute(HTTP_SERVER, request.getServerName());
        String lang = _request.getParameter("lang");
        Object language = "";
        if (lang != null && lang.trim().length() > 0) {
            String name = lang.replace('-', '_');
            if (Language.support(name) && !lang.equalsIgnoreCase(this.settings.get("language"))) {
                String[] local = name.split("_");
                context.setAttribute("language", name);
                language = "lang=" + local[0] + "-" + local[1].toUpperCase() + "&";
            }
        } else {
            context.removeAttribute("language");
        }
        Object url_prefix = "/";
        if (this.settings.get("default.url_rewrite") != null && !"enabled".equalsIgnoreCase(this.settings.get("default.url_rewrite"))) {
            url_prefix = "/?" + (String)language + "q=";
        }
        if ((hostName = this.settings.get("default.hostname")) != null) {
            if (hostName.length() <= 3) {
                hostName = request.getServerName();
            }
        } else {
            hostName = request.getServerName();
        }
        String http_protocol = "http://";
        boolean ssl = false;
        String ssl_enabled = this.settings.get("ssl.enabled");
        if (ssl_enabled != null && (ssl = Boolean.parseBoolean(ssl_enabled))) {
            http_protocol = "https://";
        }
        if (request.getServerPort() == 80) {
            context.setAttribute(HTTP_HOST, http_protocol + hostName + (String)url_prefix);
        } else {
            context.setAttribute(HTTP_HOST, http_protocol + hostName + ":" + request.getServerPort() + (String)url_prefix);
        }
        context.setAttribute(METHOD, request.getMethod());
        String query = _request.getParameter("q");
        try {
            if (query != null) {
                if (query.indexOf(63) != -1) {
                    query = query.substring(0, query.indexOf(63));
                }
                query = StringUtilities.htmlSpecialChars(query);
                if (_request.getParameter("output") != null && "function".equalsIgnoreCase(_request.getParameter("output"))) {
                    ApplicationManager.call(query, context);
                } else {
                    Object message = ApplicationManager.call(query, context);
                    if (message != null) {
                        ((PrintWriter)_response.get()).println(message);
                    } else {
                        ((PrintWriter)_response.get()).println("No response retrieved!");
                    }
                    ((PrintWriter)_response.get()).close();
                }
            } else {
                ((PrintWriter)_response.get()).println(ApplicationManager.call(this.settings.get("default.home.page"), context));
                ((PrintWriter)_response.get()).close();
            }
        }
        catch (ApplicationException e) {
            _response.setStatus(ResponseStatus.valueOf(e.getStatus()));
            try {
                HttpSession session = request.getSession();
                session.setAttribute("error", (Object)e);
                if (!Boolean.parseBoolean(this.settings.get("default.error.process"))) {
                    String defaultErrorPage = this.settings.get("default.error.page");
                    Reforward forward = new Reforward(_request, _response);
                    forward.setDefault((String)(defaultErrorPage.trim().length() == 0 ? "/?q=error" : "/?q=" + defaultErrorPage));
                    forward.forward();
                }
            }
            catch (ApplicationException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void start() throws ApplicationException {
        this.settings = new Settings();
        if (this.settings.get("default.file.encoding") != null) {
            this.charsetName = this.settings.get("default.file.encoding");
        }
        if (this.charsetName == null || this.charsetName.trim().length() == 0) {
            this.charsetName = System.getProperty("file.encoding");
        } else {
            System.setProperty("file.encoding", this.charsetName);
        }
        this.settings.set("language", "zh_CN");
        if (this.settings.get("system.directory") == null) {
            this.settings.set("system.directory", this.path);
        }
        ApplicationManager.init(this.settings);
    }

    @Override
    public void stop() {
        System.out.println("Stopping...");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        long now = System.currentTimeMillis();
        resp.addHeader("Cache-Control", "public, max-age=86400, must-revalidate");
        resp.setDateHeader("Expires", now + 86400000L);
        String uri = req.getRequestURI().replaceAll("^/+", "");
        if (uri.length() > 1) {
            File resource;
            System.out.println("Request URI:" + uri);
            if (uri.indexOf(47) != -1) {
                uri = uri.substring(0, uri.indexOf("/"));
            }
            if ((resource = new File(uri)).exists()) {
                System.out.println("Resource exists:" + uri);
                chain.doFilter(request, response);
            } else {
                System.out.println("Resource exists:" + uri);
                this.service(req, resp);
            }
        } else {
            this.service(req, resp);
        }
    }

    public void destroy() {
        this.stop();
    }

    @Override
    public void run() {
    }
}

