/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.handler;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;
import org.tinystruct.ApplicationContext;
import org.tinystruct.application.Context;
import org.tinystruct.http.CookieImpl;
import org.tinystruct.http.Header;
import org.tinystruct.http.Headers;
import org.tinystruct.http.Request;
import org.tinystruct.http.RequestBuilder;
import org.tinystruct.http.Response;
import org.tinystruct.http.ResponseBuilder;
import org.tinystruct.http.ResponseHeaders;
import org.tinystruct.http.Version;
import org.tinystruct.http.security.JWTManager;
import org.tinystruct.system.ApplicationManager;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Language;
import org.tinystruct.system.util.StringUtilities;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final Configuration<String> configuration;
    private Context context;
    private Request<FullHttpRequest> request;

    public HttpRequestHandler(Configuration<String> configuration) {
        this.configuration = configuration;
    }

    public HttpRequestHandler(Configuration<String> configuration, Context context) {
        this(configuration);
        this.context = context;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        if (this.context == null) {
            this.context = new ApplicationContext();
        }
        this.request = new RequestBuilder(msg);
        this.service(ctx, this.request, this.context);
    }

    private void service(ChannelHandlerContext ctx, Request request, Context context) {
        ByteBuf resp;
        Object message;
        String auth;
        Headers headers = request.headers();
        if (headers.get(Header.AUTHORIZATION) != null && (auth = headers.get(Header.AUTHORIZATION).toString()) != null && auth.startsWith("Bearer ")) {
            JWTManager manager = new JWTManager();
            String secret = this.configuration.get("jwt.secret");
            if (secret != null) {
                manager.withSecret(secret);
            }
            String token = auth.substring(7);
            try {
                Jws<Claims> claims = manager.parseToken(token);
                context.setAttribute("CLAIMS", claims);
            }
            catch (ExpiredJwtException | MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException e) {
                ByteBuf resp2 = Unpooled.copiedBuffer((CharSequence)e.getMessage(), (Charset)CharsetUtil.UTF_8);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, resp2);
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)resp2.readableBytes());
                ctx.write((Object)response);
                ctx.close();
                return;
            }
        }
        HttpResponseStatus status = HttpResponseStatus.OK;
        try {
            boolean ssl;
            String hostName;
            context.setAttribute("HTTP_REQUEST", request);
            context.setAttribute("HTTP_RESPONSE", new ResponseBuilder((HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status)));
            context.setAttribute("HTTP_HOST", request.headers().get(Header.HOST));
            String lang = request.getParameter("lang");
            Object language = "";
            if (lang != null && lang.trim().length() > 0) {
                String name = lang.replace('-', '_');
                if (Language.support(name) && !lang.equalsIgnoreCase(this.configuration.get("language"))) {
                    String[] local = name.split("_");
                    context.setAttribute("language", name);
                    language = "lang=" + local[0] + "-" + local[1].toUpperCase() + "&";
                }
            } else {
                context.removeAttribute("language");
            }
            Object url_prefix = "/";
            if (this.configuration.get("default.url_rewrite") != null && !"enabled".equalsIgnoreCase(this.configuration.get("default.url_rewrite"))) {
                url_prefix = "/?" + (String)language + "q=";
            }
            if ((hostName = this.configuration.get("default.hostname")) != null) {
                if (hostName.length() <= 3) {
                    hostName = request.headers().get(Header.HOST).toString();
                }
            } else {
                hostName = request.headers().get(Header.HOST).toString();
            }
            String http_protocol = "http://";
            String ssl_enabled = this.configuration.get("ssl.enabled");
            if (ssl_enabled != null && (ssl = Boolean.parseBoolean(ssl_enabled))) {
                http_protocol = "https://";
            }
            context.setAttribute("HTTP_HOST", http_protocol + hostName + (String)url_prefix);
            context.setAttribute("METHOD", (Object)request.method());
            String query = request.query();
            if (query != null && query.length() > 1) {
                message = ApplicationManager.call(query = StringUtilities.htmlSpecialChars(query), context);
                if (null == message) {
                    message = "No response retrieved!";
                } else if (message instanceof Response) {
                    ctx.write(((Response)message).get());
                    return;
                }
            } else {
                message = ApplicationManager.call(this.configuration.get("default.home.page").toString(), context);
            }
        }
        catch (Exception e) {
            StackTraceElement[] trace = e.getStackTrace();
            message = e.getMessage();
            if (trace.length > 0 && null != e.getCause()) {
                message = e.getCause().getStackTrace()[0] + ":" + trace[0].toString();
            }
            status = HttpResponseStatus.NOT_FOUND;
        }
        try {
            resp = Unpooled.copiedBuffer((CharSequence)message.toString(), (Charset)CharsetUtil.UTF_8);
        }
        catch (Exception e) {
            resp = Unpooled.copiedBuffer((CharSequence)e.getMessage(), (Charset)CharsetUtil.UTF_8);
        }
        DefaultFullHttpResponse _response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, resp);
        ResponseBuilder response = new ResponseBuilder((HttpResponse)_response);
        ResponseHeaders responseHeaders = new ResponseHeaders(response);
        CookieImpl cookie = new CookieImpl("jsessionid");
        cookie.setValue(request.getSession().getId());
        String host = request.headers().get(Header.HOST).toString();
        cookie.setDomain(host.substring(0, host.indexOf(":")));
        cookie.setHttpOnly(true);
        cookie.setPath("/");
        cookie.setMaxAge(1800L);
        responseHeaders.add(Header.SET_COOKIE.set(cookie));
        responseHeaders.add(Header.CONTENT_TYPE.set("text/html; charset=UTF-8"));
        responseHeaders.add(Header.CONTENT_LENGTH.setInt(resp.readableBytes()));
        ctx.write(response.get());
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    private void writeResponse(Channel channel, String content, boolean forceClose, HttpMessage msg) {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8);
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)msg) && !forceClose;
        DefaultFullHttpResponse _response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buf);
        ResponseBuilder response = new ResponseBuilder((HttpResponse)_response);
        ResponseHeaders responseHeaders = new ResponseHeaders(response);
        responseHeaders.add(Header.CONTENT_TYPE.set("text/plain; charset=UTF-8"));
        responseHeaders.add(Header.CONTENT_LENGTH.setInt(buf.readableBytes()));
        if (!keepAlive) {
            responseHeaders.add(Header.CONNECTION.set((Object)Header.StandardValue.CLOSE));
        } else if (this.request.version() == Version.HTTP1_0) {
            responseHeaders.add(Header.CONNECTION.set((Object)Header.StandardValue.KEEP_ALIVE));
        }
        Object value = this.request.headers().get(Header.COOKIE);
        Set cookies = value == null ? Collections.emptySet() : ServerCookieDecoder.STRICT.decode(value.toString());
        if (!cookies.isEmpty()) {
            for (Cookie cookie : cookies) {
                responseHeaders.add(Header.SET_COOKIE.set(ServerCookieEncoder.STRICT.encode(cookie)));
            }
        }
        ChannelFuture future = channel.writeAndFlush(response.get());
        if (!keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = null;
    }
}

