/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.tinystruct.handler.ProxyHandler;
import org.tinystruct.handler.ProxyInboundHandler;

public class ProxyOutboundHandler
extends ChannelInboundHandlerAdapter
implements ProxyHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ProxyOutboundHandler.class);
    private final Channel inboundChannel;

    public ProxyOutboundHandler(Channel inboundChannel) {
        this.inboundChannel = inboundChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
    }

    public void channelRead(final ChannelHandlerContext ctx, Object msg) {
        logger.debug("{}", msg.getClass());
        this.inboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    future.channel().close();
                }
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ProxyInboundHandler.closeOnFlush(this.inboundChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ProxyInboundHandler.closeOnFlush(ctx.channel());
    }

    @Override
    public void addCodec(ChannelPipeline pipeline, ChannelHandler ... handler) {
    }

    @Override
    public ChannelHandler[] initCodecs() {
        return new ChannelHandler[0];
    }
}

