/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.handler;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.tinystruct.ApplicationException;
import org.tinystruct.http.Header;
import org.tinystruct.http.Headers;
import org.tinystruct.http.Request;
import org.tinystruct.http.Response;

public class Reforward {
    private String fromURL = "";
    private String currentURL = "";
    private final Response response;

    public Reforward(Request request, Response response) throws ApplicationException {
        this.response = response;
        this.currentURL = request.query() != null ? request.uri() + "?" + request.query() : request.uri();
        Headers headers = request.headers();
        if (request.getParameter("from") != null && request.getParameter("from").trim().length() > 0) {
            this.setDefault(request.getParameter("from"));
        } else {
            this.fromURL = headers.get(Header.REFERER) != null && headers.get(Header.REFERER).toString().startsWith("http://" + request.headers().get(Header.SERVER)) ? headers.get(Header.REFERER).toString() : "/";
        }
    }

    public void setDefault(String url) throws ApplicationException {
        if (url.indexOf("%3A") != -1) {
            try {
                this.fromURL = URLDecoder.decode(url, "utf8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        } else {
            this.fromURL = url;
        }
    }

    public void match(String action, String fromURL) {
        String action1 = "";
        if (action1.equals(action)) {
            this.fromURL = fromURL;
        }
    }

    public Response forward() throws ApplicationException {
        try {
            this.response.sendRedirect(this.fromURL);
        }
        catch (IOException io) {
            throw new ApplicationException(io.getMessage(), io);
        }
        return this.response;
    }

    public String getCurrentURL() throws ApplicationException {
        try {
            return URLEncoder.encode(this.currentURL, "utf8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public String getFromURL() throws ApplicationException {
        try {
            return URLEncoder.encode(this.fromURL, "utf8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }
}

