/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import java.util.Locale;

public enum Header {
    ACCEPT("Accept", new StandardValue[]{StandardValue.APPLICATION_JSON, StandardValue.APPLICATION_X_WWW_FORM_URLENCODED}),
    ACCEPT_CHARSET("Accept-Charset"),
    ACCEPT_ENCODING("Accept-Encoding"),
    ACCEPT_LANGUAGE("Accept-Language"),
    ACCEPT_RANGES("Accept-Ranges"),
    ACCEPT_PATCH("Accept-Patch"),
    ACCESS_CONTROL_ALLOW_CREDENTIALS("Access-Control-Allow-Credentials"),
    ACCESS_CONTROL_ALLOW_HEADERS("Access-Control-Allow-Headers"),
    ACCESS_CONTROL_ALLOW_METHODS("Access-Control-Allow-Methods"),
    ACCESS_CONTROL_ALLOW_ORIGIN("Access-Control-Allow-Origin"),
    ACCESS_CONTROL_EXPOSE_HEADERS("Access-Control-Expose-Headers"),
    ACCESS_CONTROL_MAX_AGE("Access-Control-Max-Age"),
    ACCESS_CONTROL_REQUEST_HEADERS("Access-Control-Request-Headers"),
    ACCESS_CONTROL_REQUEST_METHOD("Access-Control-Request-Method"),
    AGE("Age"),
    ALLOW("Allow"),
    AUTHORIZATION("Authorization"),
    CACHE_CONTROL("Cache-Control"),
    CONNECTION("Connection"),
    CONTENT_BASE("Content-Base"),
    CONTENT_ENCODING("Content-Encoding"),
    CONTENT_LANGUAGE("Content-Language"),
    CONTENT_LENGTH("Content-Length"),
    CONTENT_LOCATION("Content-Location"),
    CONTENT_TRANSFER_ENCODING("Content-Transfer-Encoding"),
    CONTENT_MD5("Content-MD5"),
    CONTENT_RANGE("Content-Range"),
    CONTENT_TYPE("Content-Type"),
    COOKIE("Cookie"),
    DATE("Date"),
    ETAG("ETag"),
    EXPECT("Expect"),
    EXPIRES("Expires"),
    FROM("From"),
    HOST("Host"),
    IF_MATCH("If-Match"),
    IF_MODIFIED_SINCE("If-Modified-Since"),
    IF_NONE_MATCH("If-None-Match"),
    IF_RANGE("If-Range"),
    IF_UNMODIFIED_SINCE("If-Unmodified-Since"),
    LAST_MODIFIED("Last-Modified"),
    LOCATION("Location"),
    MAX_FORWARDS("Max-Forwards"),
    ORIGIN("Origin"),
    PRAGMA("Pragma"),
    PROXY_AUTHENTICATE("Proxy-Authenticate"),
    PROXY_AUTHORIZATION("Proxy-Authorization"),
    RANGE("Range"),
    REFERER("Referer"),
    RETRY_AFTER("Retry-After"),
    SEC_WEBSOCKET_KEY1("Sec-WebSocket-Key1"),
    SEC_WEBSOCKET_KEY2("Sec-WebSocket-Key2"),
    SEC_WEBSOCKET_LOCATION("Sec-WebSocket-Location"),
    SEC_WEBSOCKET_ORIGIN("Sec-WebSocket-Origin"),
    SEC_WEBSOCKET_PROTOCOL("Sec-WebSocket-Protocol"),
    SEC_WEBSOCKET_VERSION("Sec-WebSocket-Version"),
    SEC_WEBSOCKET_KEY("Sec-WebSocket-Key"),
    SEC_WEBSOCKET_ACCEPT("Sec-WebSocket-Accept"),
    SEC_FETCH_DEST("Sec-Fetch-Dest"),
    SEC_FETCH_MODE("Sec-Fetch-Mode"),
    SEC_FETCH_SITE("Sec-Fetch-Site"),
    SEC_FETCH_USER("Sec-Fetch-User"),
    SERVER("Server"),
    SET_COOKIE("Set-Cookie"),
    SET_COOKIE2("Set-Cookie2"),
    TE("TE"),
    TRAILER("Trailer"),
    TRANSFER_ENCODING("Transfer-Encoding"),
    UPGRADE("Upgrade"),
    UPGRADE_INSECURE_REQUESTS("Upgrade-Insecure-Requests"),
    USER_AGENT("User-Agent"),
    VARY("Vary"),
    VIA("Via"),
    WARNING("Warning"),
    WEBSOCKET_LOCATION("WebSocket-Location"),
    WEBSOCKET_ORIGIN("WebSocket-Origin"),
    WEBSOCKET_PROTOCOL("WebSocket-Protocol"),
    WWW_AUTHENTICATE("WWW-Authenticate"),
    X_REQUESTED_WITH("X-Requested-With");

    private final String name;
    private StandardValue[] options;
    private Object value;

    private Header(String name) {
        this.name = name;
    }

    private Header(String name, StandardValue[] options) {
        this.name = name;
        this.options = options;
    }

    public static Header value0f(String name) {
        return Header.valueOf(Header.class, name.toUpperCase(Locale.ROOT).replaceAll("-", "_"));
    }

    public String toString() {
        return this.name;
    }

    public StandardValue[] getOptions() {
        return this.options;
    }

    public void setOptions(StandardValue[] options) {
        this.options = options;
    }

    public Header set(Object value) {
        this.value = value;
        return this;
    }

    public Header setInt(int readableBytes) {
        this.value = readableBytes;
        return this;
    }

    public Object value() {
        return this.value;
    }

    public static enum StandardValue {
        APPLICATION_JSON("application/json"),
        APPLICATION_X_WWW_FORM_URLENCODED("application/x-www-form-urlencoded"),
        BASE64("base64"),
        BINARY("binary"),
        BOUNDARY("boundary"),
        BYTES("bytes"),
        CHARSET("charset"),
        CHUNKED("chunked"),
        CLOSE("close"),
        COMPRESS("compress"),
        CONTINUE("100-continue"),
        DEFLATE("deflate"),
        GZIP("gzip"),
        GZIP_DEFLATE("gzip,deflate"),
        IDENTITY("identity"),
        KEEP_ALIVE("keep-alive"),
        MAX_AGE("max-age"),
        MAX_STALE("max-stale"),
        MIN_FRESH("min-fresh"),
        MULTIPART_FORM_DATA("multipart/form-data"),
        MUST_REVALIDATE("must-revalidate"),
        NO_CACHE("no-cache"),
        NO_STORE("no-store"),
        NO_TRANSFORM("no-transform"),
        NONE("none"),
        ONLY_IF_CACHED("only-if-cached"),
        PRIVATE("private"),
        PROXY_REVALIDATE("proxy-revalidate"),
        PUBLIC("public"),
        QUOTED_PRINTABLE("quoted-printable"),
        S_MAXAGE("s-maxage"),
        TRAILERS("trailers"),
        UPGRADE("Upgrade"),
        WEBSOCKET("WebSocket");

        private final String value;

        private StandardValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

