/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinystruct.http.Session;
import org.tinystruct.http.SessionManager;

public class MemorySession
implements Session {
    private final Map<String, Object> storage = new ConcurrentHashMap<String, Object>();
    private final String sessionId;

    public MemorySession(String sessionId) {
        this.sessionId = sessionId;
        SessionManager.getInstance().setSession(sessionId, this);
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.storage.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.storage.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.storage.remove(key);
    }
}

