/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.util.StandardSessionIdGenerator;
import org.tinystruct.data.FileEntity;
import org.tinystruct.http.Cookie;
import org.tinystruct.http.CookieImpl;
import org.tinystruct.http.Header;
import org.tinystruct.http.Headers;
import org.tinystruct.http.MemorySession;
import org.tinystruct.http.Method;
import org.tinystruct.http.Request;
import org.tinystruct.http.RequestWrapper;
import org.tinystruct.http.Session;
import org.tinystruct.http.SessionManager;
import org.tinystruct.http.Version;

public class RequestBuilder
extends RequestWrapper<FullHttpRequest> {
    private final SessionManager manager = SessionManager.getInstance();
    private final Headers headers = new Headers();
    private final Cookie[] cookies;
    private final HashMap<String, List<String>> params = new HashMap();
    private String query;
    private Version version;
    private Method method;
    private String uri = ((FullHttpRequest)this.request).uri();

    public RequestBuilder(FullHttpRequest request) {
        super(request);
        QueryStringDecoder q;
        ByteBuf content = request.content();
        content.readableBytes();
        HttpHeaders headers = request.headers();
        headers.forEach(h -> this.headers.add(Header.value0f((String)h.getKey()).set(h.getValue())));
        String value = request.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        Set _cookies = value == null ? Collections.emptySet() : ServerCookieDecoder.STRICT.decode(value);
        int i = _cookies.size();
        this.cookies = new Cookie[i];
        for (io.netty.handler.codec.http.cookie.Cookie _cookie : _cookies) {
            CookieImpl cookie = new CookieImpl(_cookie.name());
            cookie.setValue(_cookie.value());
            cookie.setDomain(_cookie.domain());
            cookie.setHttpOnly(_cookie.isHttpOnly());
            cookie.setMaxAge(_cookie.maxAge());
            cookie.setPath(_cookie.path());
            cookie.setSecure(_cookie.isSecure());
            this.cookies[--i] = cookie;
        }
        if (content.capacity() > 0) {
            switch (this.headers.get(Header.CONTENT_TYPE).toString()) {
                case "multipart/form-data": {
                    DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
                    HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)factory, (HttpRequest)request);
                    while (decoder.hasNext()) {
                        InterfaceHttpData fileData = decoder.next();
                        if (fileData == null || fileData.getHttpDataType() != InterfaceHttpData.HttpDataType.FileUpload) continue;
                        ArrayList<FileEntity> list = new ArrayList<FileEntity>();
                        list.add((FileEntity)fileData);
                    }
                    break;
                }
            }
            String requestBody = content.toString(CharsetUtil.UTF_8);
            String[] args = requestBody.split("&");
            for (i = 0; i < args.length; ++i) {
                if (!args[i].contains("=")) continue;
                String[] pair = args[i].split("=");
                this.setParameter(pair[0], List.of(pair[1]));
            }
        }
        if (!(q = this.parseQuery(request.uri(), true)).path().isEmpty()) {
            this.query = q.parameters().get("q") != null ? (String)((List)q.parameters().get("q")).get(0) : "";
        }
    }

    private QueryStringDecoder parseQuery(String uri, boolean hasPath) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri, hasPath);
        Map parameters = decoder.parameters();
        for (Map.Entry element : parameters.entrySet()) {
            this.setParameter((String)element.getKey(), (List)element.getValue());
        }
        return decoder;
    }

    private void setParameter(String name, List<String> values) {
        this.params.put(name, values);
    }

    public Session getSession(String id) {
        return this.manager.getSession(id);
    }

    @Override
    public Session getSession(String id, boolean generated) {
        if (this.manager.getSession(id) == null && generated) {
            this.manager.setSession(id, new MemorySession(id));
        }
        return this.manager.getSession(id);
    }

    @Override
    public Session getSession() {
        String sessionId = null;
        String cookieValue = ((FullHttpRequest)this.request).headers().get(Header.COOKIE.name());
        if (cookieValue != null) {
            String[] cookies;
            for (String cookie1 : cookies = cookieValue.split(";")) {
                String[] _cookie = cookie1.split("=");
                if (!_cookie[0].trim().equalsIgnoreCase("jsessionid")) continue;
                sessionId = _cookie[1];
                break;
            }
        }
        if (sessionId != null) {
            return this.getSession(sessionId, true);
        }
        return this.getSession(new StandardSessionIdGenerator().generateSessionId(), true);
    }

    @Override
    public String query() {
        return this.query;
    }

    public Object stream() {
        return null;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    @Override
    public Method method() {
        this.setMethod(Method.valueOf(((FullHttpRequest)this.request).method().name()));
        return this.method;
    }

    @Override
    public Request setMethod(Method method) {
        this.method = method;
        return this;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public Request setUri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String getParameter(String name) {
        if (null != this.params.get(name) && this.params.get(name).size() > 0) {
            return this.params.get(name).get(0);
        }
        return null;
    }

    @Override
    public Cookie[] cookies() {
        return this.cookies;
    }
}

