/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Map;
import org.tinystruct.http.Cookie;
import org.tinystruct.http.Header;
import org.tinystruct.http.Headers;
import org.tinystruct.http.Response;
import org.tinystruct.http.ResponseHeaders;
import org.tinystruct.http.ResponseStatus;
import org.tinystruct.http.ResponseWrapper;
import org.tinystruct.http.Version;

public class ResponseBuilder
extends ResponseWrapper<HttpResponse> {
    private final Headers headers = new ResponseHeaders(this);
    private ResponseStatus status;
    private Version version;

    public ResponseBuilder(HttpResponse response) {
        super(response);
    }

    public void setContentType(String contentType) {
        ((HttpResponse)this.response).headers().add(Header.CONTENT_TYPE.name(), (Object)contentType);
    }

    @Override
    public void addHeader(String header, Object value) {
        if (value instanceof Integer) {
            ((HttpResponse)this.response).headers().addInt((CharSequence)header, ((Integer)value).intValue());
        } else {
            ((HttpResponse)this.response).headers().add(header, value);
        }
    }

    public String getHeader(String header) {
        return ((HttpResponse)this.response).headers().get(header);
    }

    public void addCookie(Cookie cookie) {
        this.addHeader(Header.SET_COOKIE.toString(), cookie.toString());
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public ResponseStatus status() {
        return this.status;
    }

    public Response setStatus(ResponseStatus status) {
        this.status = status;
        ((HttpResponse)this.response).setStatus(HttpResponseStatus.valueOf((int)status.code()));
        return this;
    }

    @Override
    public Headers headers() {
        for (Map.Entry header : ((HttpResponse)this.response).headers()) {
            this.headers.add(Header.valueOf((String)header.getKey()).set(header.getValue()));
        }
        return this.headers;
    }

    public HttpResponse get() {
        return (HttpResponse)this.response;
    }

    @Override
    public void sendRedirect(String url) throws IOException {
        ResponseHeaders responseHeaders = new ResponseHeaders(this);
        responseHeaders.add(Header.CONTENT_LENGTH.setInt(0));
        responseHeaders.add(Header.LOCATION.set(url));
        ((HttpResponse)this.response).setStatus(HttpResponseStatus.valueOf((int)307));
    }
}

