/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tinystruct.ApplicationException;
import org.tinystruct.http.Callback;
import org.tinystruct.http.Method;

public class URLRequest {
    private URL url;
    private Map<String, String> headers;
    private Method method = Method.GET;

    public URLRequest(URL url) {
        this.url = url;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public URLRequest setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public URLRequest setUrl(URL url) {
        this.url = url;
        return this;
    }

    public byte[] send(Map<String, Object> parameters) throws ApplicationException, URISyntaxException {
        try {
            return this.send(parameters, new Callback<ByteArrayOutputStream>(){

                @Override
                public byte[] process(ByteArrayOutputStream out) throws ApplicationException {
                    return out.toByteArray();
                }
            });
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
    }

    public byte[] send(Map<String, Object> parameters, Callback<ByteArrayOutputStream> callback) throws ApplicationException, IOException {
        int len;
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestProperty("accept", "*/*");
        connection.setRequestProperty("connection", "Keep-Alive");
        connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
        connection.setReadTimeout(10000);
        connection.setConnectTimeout(15000);
        connection.setRequestMethod(this.method.name());
        if (this.headers != null) {
            Set<Map.Entry<String, String>> set = this.headers.entrySet();
            for (Map.Entry<String, String> key : set) {
                connection.setRequestProperty(key.getKey(), key.getValue());
            }
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        if (parameters != null && parameters.size() > 0) {
            OutputStream os = connection.getOutputStream();
            String query = this.buildQuery(parameters);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write(query);
            writer.flush();
            writer.close();
            os.close();
        }
        connection.connect();
        InputStream in = connection.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((len = in.read(bytes)) != -1) {
            out.write(bytes, 0, len);
        }
        in.close();
        out.close();
        connection.disconnect();
        return callback.process(out);
    }

    private String buildQuery(Map<String, Object> parameters) {
        Set<Map.Entry<String, Object>> keySet = parameters.entrySet();
        Iterator<Map.Entry<String, Object>> iterator = keySet.iterator();
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (first) {
                first = false;
            } else {
                buffer.append("&");
            }
            buffer.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return buffer.toString();
    }
}

