/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.crypto.MacProvider;
import java.security.Key;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import javax.crypto.SecretKey;
import org.tinystruct.data.component.Builder;

public class JWTManager {
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.HS256;
    private static final SecretKey SECRET_KEY = MacProvider.generateKey((SignatureAlgorithm)SIGNATURE_ALGORITHM);
    private byte[] base64Key;

    public JWTManager withSecret(String secret) {
        this.base64Key = Base64.getEncoder().encode(secret.getBytes());
        return this;
    }

    public String createToken(String subject, Builder builder, long validity) {
        Instant now = Instant.now();
        Date expiryDate = Date.from(now.plus(Duration.ofHours(validity)));
        JwtBuilder jwts = Jwts.builder().setSubject(subject).setExpiration(expiryDate).setIssuedAt(Date.from(now));
        builder.forEach((arg_0, arg_1) -> ((JwtBuilder)jwts).claim(arg_0, arg_1));
        if (this.base64Key != null) {
            jwts.signWith(SIGNATURE_ALGORITHM, this.base64Key);
        } else {
            jwts.signWith(SIGNATURE_ALGORITHM, (Key)SECRET_KEY);
        }
        return jwts.compact();
    }

    public Jws<Claims> parseToken(String compactToken) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        JwtParser parser = Jwts.parser();
        if (this.base64Key != null) {
            parser.setSigningKey(this.base64Key);
        } else {
            parser.setSigningKey((Key)SECRET_KEY);
        }
        return parser.parseClaimsJws(compactToken);
    }
}

