/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http.servlet;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import org.tinystruct.http.Header;
import org.tinystruct.http.Request;
import org.tinystruct.transfer.http.upload.ContentDisposition;

public class MultipartFormData {
    protected final Request<ServletInputStream> request;
    protected ServletInputStream inputStream;
    protected String boundary;
    protected boolean end = false;
    protected int bufferSize = 4096;

    public MultipartFormData(Request request) throws ServletException {
        this.request = request;
        this.parseRequest();
    }

    public ContentDisposition getNextPart() {
        String disposition = this.readLine();
        if (disposition != null && disposition.startsWith("Content-Disposition")) {
            try {
                disposition = new String(disposition.getBytes("ISO-8859-1"), "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String name = MultipartFormData.parseDispositionName(disposition);
            String filename = MultipartFormData.parseDispositionFilename(disposition);
            String contentType = null;
            byte[] data = null;
            if (filename != null) {
                filename = new File(filename).getName();
                int colonIndex = filename.indexOf(":");
                int slashIndex = filename.lastIndexOf("\\");
                if (colonIndex > -1 && slashIndex > -1) {
                    filename = filename.substring(slashIndex + 1, filename.length());
                }
                contentType = this.readLine();
                contentType = MultipartFormData.parseContentType(contentType);
            }
            StringBuilder textData = new StringBuilder();
            this.readLine();
            String line = this.readLine();
            while (line != null && !line.startsWith(this.boundary)) {
                textData.append(line);
                line = this.readLine();
            }
            String text = textData.toString();
            if (text.endsWith("\r\n")) {
                textData.setLength(textData.length() - 2);
            }
            if (text.endsWith("\n")) {
                textData.setLength(textData.length() - 1);
            }
            text = textData.toString();
            try {
                data = text.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                data = text.getBytes();
            }
            return new ContentDisposition(name, filename, contentType, data);
        }
        return null;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    protected void parseRequest() throws ServletException {
        this.boundary = MultipartFormData.parseBoundary(this.request.headers().get(Header.CONTENT_TYPE).toString());
        this.inputStream = this.request.stream();
        if (this.boundary == null || this.boundary.length() < 1) {
            this.boundary = MultipartFormData.parseBoundary(this.request.headers().get(Header.CONTENT_TYPE).toString());
        }
        if (this.boundary == null || this.boundary.length() < 1) {
            throw new ServletException("MultipartFormData: cannot retrieve boundary for multipart request");
        }
        if (!this.readLine().startsWith(this.boundary)) {
            throw new ServletException("MultipartFormData: invalid multipart request data");
        }
    }

    public static String parseBoundary(String contentType) {
        if (contentType.lastIndexOf("boundary=") != -1) {
            String _boundary = "--" + contentType.substring(contentType.lastIndexOf("boundary=") + 9);
            if (_boundary.endsWith("\n")) {
                return _boundary.substring(0, _boundary.length() - 1);
            }
            return _boundary;
        }
        return null;
    }

    public static String parseContentType(String contentTypeString) {
        int endLineIndex;
        int nameIndex = contentTypeString.indexOf("Content-Type: ");
        if (nameIndex != -1 && (endLineIndex = contentTypeString.indexOf("\n")) != -1) {
            return contentTypeString.substring(nameIndex + 14, endLineIndex);
        }
        return null;
    }

    public static String parseDispositionName(String dispositionString) {
        return MultipartFormData.parseForAttribute("name", dispositionString);
    }

    public static String parseDispositionFilename(String dispositionString) {
        return MultipartFormData.parseForAttribute("filename", dispositionString);
    }

    public static String parseForAttribute(String attribute, String parseString) {
        int endQuoteIndex;
        int nameIndex = parseString.indexOf(attribute + "=\"");
        if (nameIndex != -1 && (endQuoteIndex = parseString.indexOf("\"", nameIndex + attribute.length() + 3)) != -1) {
            return parseString.substring(nameIndex + attribute.length() + 2, endQuoteIndex);
        }
        return null;
    }

    protected String readLine() {
        int bytesRead;
        byte[] bufferByte = new byte[this.bufferSize];
        try {
            bytesRead = this.inputStream.readLine(bufferByte, 0, this.bufferSize);
        }
        catch (IOException ioe) {
            return null;
        }
        if (bytesRead == -1) {
            this.end = true;
            return null;
        }
        try {
            return new String(bufferByte, 0, bytesRead, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(bufferByte);
        }
    }
}

