/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.tinystruct.http.Cookie;
import org.tinystruct.http.CookieImpl;
import org.tinystruct.http.Header;
import org.tinystruct.http.Headers;
import org.tinystruct.http.MemorySession;
import org.tinystruct.http.Method;
import org.tinystruct.http.Request;
import org.tinystruct.http.RequestWrapper;
import org.tinystruct.http.Session;
import org.tinystruct.http.SessionManager;
import org.tinystruct.http.Version;

public class RequestBuilder
extends RequestWrapper<HttpServletRequest> {
    private final SessionManager manager = SessionManager.getInstance();
    private final Headers headers = new Headers();
    private final Cookie[] cookies;
    private final Session memorySession;
    private Version version;
    private Method method;
    private String uri;

    public RequestBuilder(HttpServletRequest request) {
        super(request);
        Enumeration headerNames = ((HttpServletRequest)this.request).getHeaderNames();
        while (headerNames.hasMoreElements()) {
            try {
                String h = (String)headerNames.nextElement();
                this.headers.add(Header.value0f(h).set(((HttpServletRequest)this.request).getHeader(h)));
            }
            catch (IllegalArgumentException h) {}
        }
        this.setUri(((HttpServletRequest)this.request).getRequestURI());
        this.setMethod(Method.valueOf(((HttpServletRequest)this.request).getMethod()));
        javax.servlet.http.Cookie[] _cookies = ((HttpServletRequest)this.request).getCookies();
        if (_cookies != null) {
            int i = _cookies.length;
            this.cookies = new Cookie[i];
            for (javax.servlet.http.Cookie _cookie : _cookies) {
                CookieImpl cookie = new CookieImpl(_cookie.getName());
                cookie.setValue(_cookie.getValue());
                cookie.setDomain(_cookie.getDomain());
                cookie.setHttpOnly(_cookie.isHttpOnly());
                cookie.setMaxAge(_cookie.getMaxAge());
                cookie.setPath(_cookie.getPath());
                cookie.setSecure(_cookie.getSecure());
                this.cookies[--i] = cookie;
            }
        } else {
            this.cookies = new Cookie[0];
        }
        HttpSession session = ((HttpServletRequest)this.request).getSession();
        String sessionId = session.getId();
        this.memorySession = this.getSession(sessionId, true);
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String s = (String)attributeNames.nextElement();
            this.memorySession.setAttribute(s, session.getAttribute(s));
        }
    }

    public Session getSession(String id) {
        return this.manager.getSession(id);
    }

    @Override
    public Session getSession(String id, boolean generated) {
        if (this.manager.getSession(id) == null && generated) {
            this.manager.setSession(id, new MemorySession(id));
        }
        return this.manager.getSession(id);
    }

    @Override
    public Session getSession() {
        return this.memorySession;
    }

    @Override
    public String query() {
        return ((HttpServletRequest)this.request).getQueryString();
    }

    public ServletInputStream stream() {
        try {
            return ((HttpServletRequest)this.request).getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    @Override
    public Method method() {
        return this.method;
    }

    @Override
    public Request setMethod(Method method) {
        this.method = method;
        return this;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public Request setUri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String getParameter(String name) {
        return ((HttpServletRequest)this.request).getParameter(name);
    }

    @Override
    public Cookie[] cookies() {
        return this.cookies;
    }
}

