/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.tinystruct.http.Cookie;
import org.tinystruct.http.Header;
import org.tinystruct.http.Headers;
import org.tinystruct.http.Response;
import org.tinystruct.http.ResponseHeaders;
import org.tinystruct.http.ResponseStatus;
import org.tinystruct.http.ResponseWrapper;
import org.tinystruct.http.Version;

public class ResponseBuilder
extends ResponseWrapper<HttpServletResponse> {
    private final Headers headers = new ResponseHeaders(this);
    private PrintWriter printWriter;
    private ResponseStatus status;
    private Version version;

    public ResponseBuilder(HttpServletResponse response) {
        super(response);
        try {
            this.printWriter = response.getWriter();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String headerName : ((HttpServletResponse)this.response).getHeaderNames()) {
            this.headers.add(Header.value0f(headerName).set(((HttpServletResponse)this.response).getHeader(headerName)));
        }
    }

    public void setContentType(String contentType) {
        ((HttpServletResponse)this.response).setContentType(contentType);
    }

    @Override
    public void addHeader(String header, Object value) {
        ((HttpServletResponse)this.response).addHeader(header, value.toString());
    }

    public String getHeader(String header) {
        return ((HttpServletResponse)this.response).getHeader(header);
    }

    public void addCookie(Cookie cookie) {
        this.addHeader(Header.SET_COOKIE.toString(), cookie.toString());
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public ResponseStatus status() {
        return this.status;
    }

    public Response setStatus(ResponseStatus status) {
        this.status = status;
        ((HttpServletResponse)this.response).setStatus(status.code());
        return this;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    public PrintWriter get() {
        return this.printWriter;
    }

    @Override
    public void sendRedirect(String url) throws IOException {
        ((HttpServletResponse)this.response).sendRedirect(url);
    }
}

