/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.mail;

import java.util.Vector;
import javax.mail.MessagingException;
import org.tinystruct.ApplicationException;
import org.tinystruct.mail.Connection;
import org.tinystruct.mail.POP3Connection;
import org.tinystruct.mail.SMTPConnection;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Settings;

public final class ConnectionManager
implements Runnable {
    private final Vector<Connection> list = new Vector();
    private boolean pending = false;

    private ConnectionManager() {
    }

    public static ConnectionManager getInstance() {
        return SingletonHolder.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            for (int i = 0; i < this.list.size(); ++i) {
                Connection current = this.list.get(i);
                if (current == null || current.available()) continue;
                try {
                    current.close();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
                this.list.remove(i);
            }
            this.pending = false;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Connection connection) {
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            this.list.add(connection);
            if (this.list.size() > 3 && !this.pending) {
                this.pending = true;
                new Thread(this).start();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(Configuration<String> config, Connection.PROTOCOL protocol) throws ApplicationException {
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            Connection connection;
            if (this.list.size() > 0) {
                connection = this.list.firstElement();
                this.list.remove(connection);
                if (!connection.available()) {
                    connection = this.getConnection(protocol);
                }
            } else {
                connection = protocol == Connection.PROTOCOL.SMTP ? new SMTPConnection(config) : new POP3Connection(config);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return connection;
        }
    }

    public Connection getConnection(Connection.PROTOCOL protocol) throws ApplicationException {
        return this.getConnection(new Settings("/application.properties"), protocol);
    }

    public int size() {
        return this.list.size();
    }

    private static final class SingletonHolder {
        static final ConnectionManager manager = new ConnectionManager();

        private SingletonHolder() {
        }
    }
}

