/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.mail;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.tinystruct.ApplicationException;
import org.tinystruct.mail.Connection;
import org.tinystruct.mail.ConnectionManager;
import org.tinystruct.mail.POP3Connection;
import org.tinystruct.mail.SMTPConnection;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Settings;

public class SimpleMail {
    private static final Logger logger = Logger.getLogger(SimpleMail.class.getName());
    private String username = config.get("smtp.auth.user");
    private String fromName;
    private List<InternetAddress> to;
    private List<InternetAddress> copyTo;
    private List<InternetAddress> behindCopyTo;
    private String content;
    private String subject;
    private InternetAddress toAddress;
    private MimeBodyPart mBodyPart;
    private static final Configuration<String> config = new Settings();
    private static final ConnectionManager manager = ConnectionManager.getInstance();

    public void setSubject(String mailSubject) {
        this.subject = mailSubject;
    }

    public void setBody(String mailBody) {
        this.content = mailBody;
    }

    public boolean attachFile(String fileName) {
        logger.log(Level.INFO, "\u589e\u52a0\u90ae\u4ef6\u9644\u4ef6\uff1a{}", fileName);
        this.mBodyPart = new MimeBodyPart();
        FileDataSource fileds = new FileDataSource(fileName);
        try {
            this.mBodyPart.setDataHandler(new DataHandler((DataSource)fileds));
            this.mBodyPart.setFileName(MimeUtility.encodeWord((String)fileds.getName(), (String)"utf-8", (String)"Q"));
        }
        catch (MessagingException e) {
            logger.severe("\u589e\u52a0\u90ae\u4ef6\u9644\u4ef6\uff1a" + fileName + "\u53d1\u751f\u9519\u8bef\uff01" + e);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void setFrom(String fromName) {
        this.fromName = fromName;
    }

    public void setTo(String to) throws ApplicationException {
        try {
            this.toAddress = new InternetAddress(to);
        }
        catch (AddressException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public void addTo(String to) throws ApplicationException {
        if (this.to == null) {
            this.to = new ArrayList<InternetAddress>();
        }
        try {
            this.to.add(new InternetAddress(to));
        }
        catch (AddressException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public void addCopyTo(String copyto) throws AddressException {
        if (this.copyTo == null) {
            this.copyTo = new ArrayList<InternetAddress>();
        }
        this.copyTo.add(new InternetAddress(copyto));
    }

    public void addBehindCopyTo(String copyto) throws ApplicationException {
        if (this.behindCopyTo == null) {
            this.behindCopyTo = new ArrayList<InternetAddress>();
        }
        try {
            this.behindCopyTo.add(new InternetAddress(copyto));
        }
        catch (AddressException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public boolean send() throws ApplicationException {
        SMTPConnection connection = (SMTPConnection)manager.getConnection(config, Connection.PROTOCOL.SMTP);
        Session session = connection.getSession();
        MimeMessage message = new MimeMessage(session);
        logger.log(Level.INFO, "\u6b63\u5728\u53d1\u9001\u90ae\u4ef6....");
        try {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart body = new MimeBodyPart();
            body.setHeader("Content-Transfer-Encoding", "base64");
            body.setContent((Object)this.content, "text/html;charset=utf-8");
            multipart.addBodyPart((BodyPart)body);
            if (this.mBodyPart != null) {
                multipart.addBodyPart((BodyPart)this.mBodyPart);
            }
            if (this.fromName != null && this.fromName.trim().length() > 0) {
                message.setFrom((Address)new InternetAddress(this.username, MimeUtility.encodeWord((String)this.fromName, (String)"utf-8", (String)"Q")));
            } else {
                message.setFrom((Address)new InternetAddress(this.username));
            }
            message.setSubject(MimeUtility.encodeWord((String)this.subject, (String)"utf-8", (String)"Q"));
            message.setSentDate(new Date());
            message.setContent((Multipart)multipart);
            if (this.toAddress == null) {
                if (this.to != null && this.to.size() > 0) {
                    InternetAddress[] to = new InternetAddress[this.to.size()];
                    message.addRecipients(Message.RecipientType.TO, (Address[])this.to.toArray(to));
                }
            } else {
                message.setRecipient(Message.RecipientType.TO, (Address)this.toAddress);
            }
            if (this.copyTo != null && this.copyTo.size() > 0) {
                InternetAddress[] cp = new InternetAddress[this.copyTo.size()];
                message.addRecipients(Message.RecipientType.CC, (Address[])this.copyTo.toArray(cp));
            }
            if (this.behindCopyTo != null && this.behindCopyTo.size() > 0) {
                InternetAddress[] bcp = new InternetAddress[this.behindCopyTo.size()];
                message.addRecipients(Message.RecipientType.BCC, (Address[])this.behindCopyTo.toArray(bcp));
            }
            message.saveChanges();
            connection.send((Message)message, message.getAllRecipients());
            logger.log(Level.INFO, "\u53d1\u9001\u90ae\u4ef6\u6210\u529f\uff01");
            boolean bl = true;
            return bl;
        }
        catch (MessagingException e) {
            throw new ApplicationException(e.getLocalizedMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException(e.getLocalizedMessage(), e);
        }
        finally {
            manager.flush(connection);
        }
    }

    public Message[] receive() throws ApplicationException {
        POP3Connection connection = (POP3Connection)manager.getConnection(config, Connection.PROTOCOL.POP3);
        Store store = connection.getStore();
        Message[] messages = new Message[]{};
        try {
            Folder folder = store.getFolder("INBOX");
            folder.open(1);
            messages = folder.getMessages();
            logger.info("Messages's length: " + messages.length);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return messages;
    }
}

