/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.tinystruct.Application;
import org.tinystruct.ApplicationException;
import org.tinystruct.application.Action;
import org.tinystruct.application.Actions;
import org.tinystruct.application.Context;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Settings;
import org.tinystruct.system.cli.CommandLine;

public final class ApplicationManager {
    public static final String VERSION = "0.5.5";
    private static final ConcurrentHashMap<String, Application> applications = new ConcurrentHashMap();
    private static final Actions actions = Actions.getInstance();
    private static final boolean WINDOWS = Platform.isWindows();
    private static Configuration<String> settings;
    private static volatile boolean initialized;

    private ApplicationManager() {
    }

    public static void init(Configuration<String> config) throws ApplicationException {
        settings = config;
        ApplicationManager.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws ApplicationException {
        if (initialized) {
            return;
        }
        Class<ApplicationManager> clazz = ApplicationManager.class;
        synchronized (ApplicationManager.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            settings = settings == null ? new Settings("/application.properties") : settings;
            ApplicationManager.generateDispatcherCommand(VERSION, false);
            if (settings.get("default.import.applications").trim().length() > 0) {
                String[] apps = settings.get("default.import.applications").split(";");
                for (int i = 0; i < apps.length; ++i) {
                    if (apps[i].equals("")) continue;
                    try {
                        Application app = (Application)Class.forName(apps[i]).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        app.setConfiguration(settings);
                        ApplicationManager.install(app);
                        continue;
                    }
                    catch (InstantiationException e) {
                        throw new ApplicationException(e.getMessage(), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ApplicationException(e.getMessage(), e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ApplicationException(e.getMessage(), e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ApplicationException(e.getMessage(), e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new ApplicationException(e.getMessage(), e);
                    }
                }
                initialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void generateDispatcherCommand(String version, boolean force) throws ApplicationException {
        String scriptName = WINDOWS ? "dispatcher.cmd" : "dispatcher";
        Object paths = "bin" + File.separator + scriptName;
        String origin = paths;
        Path path = Paths.get((String)paths, new String[0]);
        if (force || !Files.exists(Paths.get(scriptName, new String[0]), new LinkOption[0]) && !Files.exists(path, new LinkOption[0])) {
            try {
                while (!Files.exists(path, new LinkOption[0])) {
                    paths = ((String)paths).substring(0, ((String)paths).indexOf(File.separator));
                    path = Paths.get((String)paths, new String[0]);
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                String cmd = WINDOWS ? "@echo off\nset \"ROOT=%~dp0..\\\"\nset \"VERSION=\"" + version + "\"\nset \"classpath=%ROOT%target\\classes:%ROOT%lib\\*:%ROOT%WEB-INF\\lib\\*:%ROOT%WEB-INF\\classes\":%classpath%\n@java -cp \"%ROOT%target\\classes;%ROOT%lib\\tinystruct-%VERSION%-jar-with-dependencies.jar;%ROOT%\\lib\\*;%ROOT%WEB-INF\\lib\\*;%ROOT%WEB-INF\\classes;%USERPROFILE%\\.m2\\repository\\org\\tinystruct\\tinystruct\\%VERSION%\\tinystruct-%VERSION%-jar-with-dependencies.jar\" org.tinystruct.system.Dispatcher %*" : "#!/usr/bin/env sh\nROOT=\"$(pwd)\"\nVERSION=\"" + version + "\"\ncd \"$(dirname \"$0\")\" || exit\ncd \"../\"\ncd \"$ROOT\" || exit\nJAVA_OPTS=\"\"\nargs=\"\"\nfor arg\ndo\n str=$(echo \"$arg\" | awk  '{ string=substr($0, 0, 2); print string; }' )\n if [ \"$str\" = \"-D\" -o \"$str\" = \"-X\" ]\n then\n     JAVA_OPTS=$JAVA_OPTS\" \"$arg\n else\n     args=$args\" \"$arg\n fi\ndone\nJAR_FILE=\"$ROOT/lib/tinystruct-$VERSION-jar-with-dependencies.jar\"\nif [ ! -f \"$JAR_FILE\" ]; then\n JAR_FILE=\"\"\nelse\n JAR_FILE=$JAR_FILE\":\"\nfi\njava \\\n$JAVA_OPTS \\\n-XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/tmp/ \\\n-cp \"$ROOT/target/classes:$JAR_FILE$ROOT/lib/*:$ROOT/WEB-INF/lib/*:$ROOT/WEB-INF/classes:$HOME/.m2/repository/org/tinystruct/tinystruct/$VERSION/tinystruct-$VERSION-jar-with-dependencies.jar\" org.tinystruct.system.Dispatcher \"$@\"";
                path = Paths.get(origin, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.createFile(path, new FileAttribute[0]);
                }
                Files.write(path, cmd.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
    }

    public static void install(Application app) {
        if (!applications.containsKey(app.getName())) {
            applications.put(app.getName(), app);
        }
    }

    public static boolean uninstall(Application application) {
        applications.remove(application.getName());
        Actions actions = application.actions();
        Object[] list = actions.list().toArray();
        int i = 0;
        while (i < list.length) {
            Action action;
            if (!(action = (Action)list[i++]).getApplicationName().equalsIgnoreCase(application.getName())) continue;
            return actions.remove(action.getPathRule());
        }
        return false;
    }

    public static Application get(String clsid) {
        return applications.get(clsid);
    }

    public static Collection<Application> list() {
        return applications.values();
    }

    public static Object call(String path, Context context) throws ApplicationException {
        CommandLine command;
        if (path == null || path.trim().length() == 0) {
            throw new ApplicationException("Invalid: empty path");
        }
        String method = null;
        if (context != null && context.getAttribute("METHOD") != null) {
            method = context.getAttribute("METHOD").toString();
        }
        if (context != null && context.getAttribute("--help") != null && (command = actions.getCommand(path)) != null) {
            return command;
        }
        Action action = actions.getAction(path, method);
        if (action == null) {
            throw new ApplicationException("Access error [" + path + "]: Application has not been installed, or it has been uninstalled already.");
        }
        if (context != null) {
            context.setAttribute("REQUEST_ACTION", path);
            action.setContext(context);
        }
        return action.execute();
    }

    public static Configuration<String> getConfiguration() {
        return settings;
    }

    static {
        initialized = false;
    }
}

