/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.system.Settings;

public class ClassFileLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(ClassFileLoader.class.getName());

    private ClassFileLoader() {
    }

    public static ClassFileLoader getInstance() {
        return SingletonHolder.loader;
    }

    @Override
    public Class<?> findClass(String name) {
        Settings config = new Settings("/application.properties");
        String apps_package = (String)config.get("default.apps.package");
        String apps_package_dir = (String)config.get("default.apps.path") + "/" + apps_package.replaceAll("\\.", "/");
        StringBuilder path = new StringBuilder();
        if (((String)config.get("default.apps.path")).indexOf(47) == 0) {
            path.append(apps_package_dir);
        } else {
            path.append((String)config.get("system.directory")).append("/").append(apps_package_dir);
        }
        path.append("/").append(name);
        if (!name.endsWith(".class")) {
            path.append(".class");
        } else {
            name = name.replaceAll(".class", "");
        }
        try {
            byte[] data = this.getBytes(path.toString());
            return this.defineClass(apps_package + "." + name, data, 0, data.length);
        }
        catch (ApplicationException e) {
            logger.severe(e.getMessage());
            return null;
        }
    }

    @Override
    public Class<?> findClass(String path, String simpleClassName) {
        Settings config = new Settings("/application.properties");
        config.set("default.apps.path", path);
        return this.findClass(simpleClassName);
    }

    private byte[] getBytes(String filename) throws ApplicationException {
        File file = new File(filename);
        long len = file.length();
        byte[] raw = new byte[(int)len];
        try (FileInputStream in = new FileInputStream(file);){
            int r = in.read(raw);
            if ((long)r != len) {
                throw new ApplicationException("Cannot load the class file bytes completely, " + r + " != " + len);
            }
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return raw;
    }

    private static final class SingletonHolder {
        static final ClassFileLoader loader = new ClassFileLoader();

        private SingletonHolder() {
        }
    }
}

