/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.mockito.internal.SuppressSignatureCheck;
import org.tinystruct.AbstractApplication;
import org.tinystruct.Application;
import org.tinystruct.ApplicationContext;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.application.Context;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.system.ApplicationManager;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Settings;
import org.tinystruct.system.cli.CommandArgument;
import org.tinystruct.system.cli.CommandLine;
import org.tinystruct.system.cli.CommandOption;
import org.tinystruct.system.cli.Kernel32;
import org.tinystruct.system.util.StringUtilities;
import org.tinystruct.system.util.URLResourceLoader;
import org.tinystruct.transfer.http.ReadableByteChannelWrapper;

public class Dispatcher
extends AbstractApplication {
    private static final Logger logger = Logger.getLogger(Dispatcher.class.getName());
    private boolean virtualTerminal;

    @SuppressSignatureCheck
    public static void main(String[] args) {
        Settings config = new Settings();
        if (config.get("system.directory") == null || config.get("system.directory").equals("")) {
            config.set("system.directory", System.getProperty("user.dir"));
        }
        ApplicationContext context = new ApplicationContext();
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setConfiguration(config);
        ApplicationManager.install(dispatcher);
        if (args.length > 0) {
            String command = null;
            if (!args[0].startsWith("--")) {
                command = args[0];
            }
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("--")) {
                    if (i + 1 < args.length) {
                        String value;
                        if ((value = args[++i].trim()).length() > 0 && !value.startsWith("--")) {
                            if (context.getAttribute(arg) != null) {
                                List<String> list;
                                if (context.getAttribute(arg) instanceof List) {
                                    list = (List)context.getAttribute(arg);
                                } else {
                                    list = new ArrayList();
                                    list.add(Objects.requireNonNull(context.getAttribute(arg)).toString());
                                }
                                assert (list != null);
                                list.add(value);
                                context.setAttribute(arg, list);
                                continue;
                            }
                            context.setAttribute(arg, value);
                            continue;
                        }
                        --i;
                        context.setAttribute(arg, true);
                        continue;
                    }
                    context.setAttribute(arg, true);
                    continue;
                }
                command = arg;
            }
            if (context.getAttribute("--import") != null && !Boolean.parseBoolean(Objects.requireNonNull(context.getAttribute("--import")).toString())) {
                List<String> list = context.getAttribute("--import") instanceof List ? (List<String>)context.getAttribute("--import") : List.of(Objects.requireNonNull(context.getAttribute("--import")).toString());
                dispatcher.install(config, list);
            }
            Dispatcher.execute(command, context);
        } else {
            System.out.println(dispatcher.help());
        }
    }

    private static void execute(String command, Context context) {
        try {
            if (command != null) {
                Object o = ApplicationManager.call(command, context);
                if (o != null) {
                    System.out.println(o);
                }
            } else {
                Dispatcher dispatcher = (Dispatcher)ApplicationManager.get(Dispatcher.class.getName());
                if (context.getAttribute("--version") != null) {
                    System.out.println(dispatcher.version());
                } else if (context.getAttribute("--logo") != null) {
                    System.out.println(dispatcher.logo());
                } else if (context.getAttribute("--settings") != null) {
                    ApplicationManager.call("--settings", context);
                } else {
                    System.out.println(dispatcher.help());
                }
            }
        }
        catch (ApplicationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void install(Configuration<String> config, List<String> list) {
        Object defaults = config.get("default.import.applications");
        if (!((String)defaults).equals("")) {
            defaults = (String)defaults + ";";
        }
        config.set("default.import.applications", (String)defaults + String.join((CharSequence)";", list));
        try {
            ApplicationManager.init(config);
        }
        catch (ApplicationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void install() {
        String appName = (String)this.context.getAttribute("--app");
        if (appName == null) {
            throw new ApplicationRuntimeException("The app could not be found in the context.");
        }
        System.out.println("Installing...");
        this.install(this.getConfiguration(), List.of(appName));
        System.out.println("Completed installation for " + appName + "!");
    }

    public String update() {
        System.out.print("Checking...");
        try {
            URLResourceLoader loader = new URLResourceLoader(new URL("https://repo1.maven.org/maven2/org/tinystruct/tinystruct/maven-metadata.xml"));
            StringBuilder content = loader.getContent();
            String latestVersion = content.substring(content.indexOf("<latest>") + 8, content.indexOf("</latest>"));
            if (latestVersion.equalsIgnoreCase("0.5.5")) {
                return "\r" + this.color("You are already using the latest available Dispatcher version 0.5.5.", 32);
            }
            System.out.print("\rGot a new version " + latestVersion + "...");
            System.out.print("\rDownloading...");
            this.download(new URL("https://repo1.maven.org/maven2/org/tinystruct/tinystruct/" + latestVersion + "/tinystruct-" + latestVersion + "-jar-with-dependencies.jar"), "lib/tinystruct-" + latestVersion + "-jar-with-dependencies.jar");
            System.out.println("\nDownloaded (" + this.color(latestVersion, 32) + ").");
            System.out.print("\rUpdating..");
            ApplicationManager.generateDispatcherCommand(latestVersion, true);
        }
        catch (MalformedURLException | ApplicationException e) {
            return e.toString();
        }
        return "\rCompleted! \nRun 'bin/dispatcher --help' for more information.";
    }

    public void download(URL uri, String destination) throws ApplicationException {
        ReadableByteChannelWrapper rbc;
        try {
            Channels.newChannel(uri.openStream());
            rbc = new ReadableByteChannelWrapper(uri);
        }
        catch (Exception e) {
            throw new ApplicationException("Could not be downloaded:" + e.getMessage(), e.getCause());
        }
        if (destination.trim().length() <= 1) {
            destination = uri.toString().replaceAll("http://|https://|/", "+");
        }
        String path = new File("").getAbsolutePath() + File.separatorChar + destination;
        Path dest = Paths.get(path, new String[0]);
        try {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            if (!Files.exists(dest, new LinkOption[0])) {
                Files.createFile(dest, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            try {
                rbc.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                rbc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void download() throws ApplicationException {
        if (this.context.getAttribute("--url") != null) {
            try {
                URL uri = new URL(this.context.getAttribute("--url").toString());
                this.download(uri, uri.getFile());
            }
            catch (MalformedURLException e) {
                throw new ApplicationException(e.getMessage(), e.getCause());
            }
        }
    }

    public void exec() throws ApplicationException {
        if (this.context.getAttribute("--shell-command") == null) {
            throw new ApplicationException("Invalid shell command");
        }
        String cmd = this.context.getAttribute("--shell-command").toString();
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                System.out.println(line);
            }
            input.close();
            BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = error.readLine()) != null) {
                System.out.println(line);
            }
            error.close();
            p.destroy();
        }
        catch (Exception err) {
            throw new ApplicationException(err.getMessage(), err);
        }
    }

    public void executeQuery() throws ApplicationException {
        if (this.context.getAttribute("--query") == null) {
            throw new ApplicationException("Invalid Query.");
        }
        String query = this.context.getAttribute("--query").toString();
        try (DatabaseOperator operator = new DatabaseOperator();){
            operator.createStatement(false);
            operator.execute(query);
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        this.setAction("install", "install");
        ArrayList<CommandOption> options = new ArrayList<CommandOption>();
        options.add(new CommandOption("app", "", "Packages to be installed"));
        ((CommandLine)this.commandLines.get("install")).setOptions(options).setDescription("Install a package");
        this.setAction("update", "update");
        ((CommandLine)this.commandLines.get("update")).setDescription("Update for latest version");
        this.setAction("download", "download");
        ArrayList<CommandOption> opts = new ArrayList<CommandOption>();
        opts.add(new CommandOption("url", "", "URL resource to be downloaded"));
        CommandOption opt = new CommandOption("http.proxyHost", "127.0.0.1", "Proxy host");
        opts.add(opt);
        opt = new CommandOption("http.proxyPort", "3128", "Proxy port");
        opts.add(opt);
        ((CommandLine)this.commandLines.get("download")).setOptions(opts).setDescription("Download a resource from other servers");
        this.setAction("set", "setProperty");
        ((CommandLine)this.commandLines.get("set")).setDescription("Set system property");
        this.setAction("exec", "exec");
        ArrayList<CommandOption> execOpts = new ArrayList<CommandOption>();
        opt = new CommandOption("shell-command", "", "Commands needs to be executed");
        execOpts.add(opt);
        ((CommandLine)this.commandLines.get("exec")).setOptions(execOpts).setDescription("To execute native command(s)");
        this.setAction("say", "say");
        CommandArgument<String, String> argument = new CommandArgument<String, String>("words", "", "What you want to say");
        HashSet<CommandArgument<String, Object>> arguments = new HashSet<CommandArgument<String, Object>>();
        arguments.add(argument);
        ((CommandLine)this.commandLines.get("say")).setArguments(arguments).setDescription("Output words");
        this.setAction("--import", "");
        ((CommandLine)this.commandLines.get("--import")).setDescription("Import application");
        this.setAction("--settings", "settings");
        ((CommandLine)this.commandLines.get("--settings")).setDescription("Print settings");
        this.setAction("--logo", "logo");
        ((CommandLine)this.commandLines.get("--logo")).setDescription("Print logo");
        this.setAction("--version", "version");
        ((CommandLine)this.commandLines.get("--version")).setDescription("Print version");
        this.setAction("sql-query", "executeQuery");
        ArrayList<CommandOption> sqlOpts = new ArrayList<CommandOption>();
        opt = new CommandOption("query", "", "Query needs to be executed");
        sqlOpts.add(opt);
        ((CommandLine)this.commandLines.get("sql-query")).setOptions(sqlOpts).setDescription("SQL query needs to be executed.");
        this.setTemplateRequired(false);
    }

    public String say(String words) {
        return words;
    }

    public String setProperty(String propertyName) {
        if (this.context.getAttribute(propertyName) == null) {
            throw new ApplicationRuntimeException("The key " + propertyName + " could not be found in the context.");
        }
        String property = this.context.getAttribute(propertyName).toString();
        propertyName = propertyName.substring(2);
        System.setProperty(propertyName, property);
        return propertyName + ":" + System.getProperty(propertyName);
    }

    public void settings() {
        Object[] names = this.context.getAttributeNames();
        Arrays.sort(names);
        StringBuilder settings = new StringBuilder();
        for (Object name : names) {
            settings.append((String)name).append(":").append(this.context.getAttribute((String)name)).append("\n");
        }
        if (settings.length() > 0) {
            logger.info(settings.toString());
        }
    }

    public String logo() {
        return "\n  _/  '         _ _/  _     _ _/   \n  /  /  /) (/ _)  /  /  (/ (  /  " + this.color("0.5.5", 32) + "  \n           /                       \n";
    }

    public String color(Object s, int color) {
        if (!this.virtualTerminal && Platform.isWindows()) {
            Kernel32.INSTANCE.SetConsoleMode(Kernel32.INSTANCE.GetStdHandle(-11), 7);
            this.virtualTerminal = true;
        }
        return "\u001b[" + color + "m" + s + "\u001b[0m";
    }

    @Override
    public String version() {
        return String.format("Dispatcher (cli) (built on tinystruct-%s) \nCopyright (c) 2013-%s James M. ZHOU", "0.5.5", LocalDate.now().getYear());
    }

    @Override
    public String help() {
        StringBuilder builder = new StringBuilder("Usage: bin/dispatcher COMMAND [OPTIONS]\n");
        StringBuilder commands = new StringBuilder("Commands: \n");
        StringBuilder options = new StringBuilder("Options: \n");
        HashMap commandLines = new HashMap();
        Collection<Application> apps = ApplicationManager.list();
        apps.forEach(app -> commandLines.putAll(app.getCommandLines()));
        OptionalInt longSizeCommand = commandLines.keySet().stream().mapToInt(String::length).max();
        int max = longSizeCommand.orElse(0);
        Stream sorted = commandLines.values().stream().sorted();
        sorted.forEach(commandLine -> {
            String command = commandLine.getCommand();
            String description = commandLine.getDescription();
            if (command.startsWith("--")) {
                options.append("\t").append(StringUtilities.rightPadding(command, max, ' ')).append("\t").append(description).append("\n");
            } else {
                commands.append("\t").append(StringUtilities.rightPadding(command, max, ' ')).append("\t").append(description).append("\n");
            }
        });
        builder.append((CharSequence)commands).append("\n");
        builder.append((CharSequence)options);
        builder.append("\nRun 'bin/dispatcher COMMAND --help' for more information on a command.");
        return builder.toString();
    }

    private static class BACKGROUND_COLOR {
        public static final int black = 40;
        public static final int red = 41;
        public static final int green = 42;
        public static final int yellow = 43;
        public static final int blue = 44;
        public static final int magenta = 45;
        public static final int cyan = 46;
        public static final int white = 47;

        private BACKGROUND_COLOR() {
        }
    }

    private static class FORE_COLOR {
        public static final int black = 30;
        public static final int red = 31;
        public static final int green = 32;
        public static final int yellow = 33;
        public static final int blue = 34;
        public static final int magenta = 35;
        public static final int cyan = 36;
        public static final int white = 37;

        private FORE_COLOR() {
        }
    }
}

