/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.handler.HttpProxyHandler;
import org.tinystruct.system.Bootstrap;
import org.tinystruct.system.ProxyServer;
import org.tinystruct.system.cli.CommandLine;
import org.tinystruct.system.cli.CommandOption;

public class HttpProxyServer
extends ProxyServer
implements Bootstrap {
    private final Logger logger = Logger.getLogger(HttpProxyServer.class.getName());
    private int port = 81;
    private String remoteHost = "localhost";
    private int remotePort = 80;

    @Override
    public void init() {
        this.setAction("start", "start");
        ArrayList<CommandOption> options = new ArrayList<CommandOption>();
        options.add(new CommandOption("server-port", "", "Server port"));
        options.add(new CommandOption("remote-server-host", "", "Remote Server host"));
        options.add(new CommandOption("remote-server-port", "", "Remote Server port"));
        ((CommandLine)this.commandLines.get("start")).setOptions(options);
        this.setTemplateRequired(false);
    }

    @Override
    public String version() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws ApplicationException {
        if (this.context != null) {
            if (this.context.getAttribute("--server-port") != null) {
                this.port = Integer.parseInt(this.context.getAttribute("--server-port").toString());
            }
            if (this.context.getAttribute("--remote-server-port") != null) {
                this.remotePort = Integer.parseInt(this.context.getAttribute("--remote-server-port").toString());
            }
            if (this.context.getAttribute("--remote-server-host") != null) {
                this.remoteHost = this.context.getAttribute("--remote-server-host").toString();
            }
        }
        try {
            SslContext sslCtx;
            if (this.remotePort == 443) {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
            } else {
                sslCtx = null;
            }
            ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossgroup, this.workgroup).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler())).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    if (sslCtx != null) {
                        ch.pipeline().addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler()});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpRequestDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpProxyHandler(HttpProxyServer.this.remoteHost, HttpProxyServer.this.remotePort)});
                }
            }).childOption(ChannelOption.AUTO_READ, (Object)false);
            ChannelFuture future = bootstrap.bind(this.port).sync();
            this.logger.info("Proxy server(" + this.port + ") started.");
            future.channel().closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.stop();
        }
    }

    @Override
    public void stop() {
        this.bossgroup.shutdownGracefully();
        this.workgroup.shutdownGracefully();
    }
}

