/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.tinystruct.AbstractApplication;
import org.tinystruct.ApplicationContext;
import org.tinystruct.ApplicationException;
import org.tinystruct.handler.HttpRequestHandler;
import org.tinystruct.handler.HttpStaticFileHandler;
import org.tinystruct.system.ApplicationManager;
import org.tinystruct.system.Bootstrap;
import org.tinystruct.system.cli.CommandLine;
import org.tinystruct.system.cli.CommandOption;

public class NettyHttpServer
extends AbstractApplication
implements Bootstrap {
    private static final boolean SSL = System.getProperty("ssl") != null;
    private int port = 8080;
    private static final int MAX_CONTENT_LENGTH = 102400;
    private final EventLoopGroup bossgroup;
    private final EventLoopGroup workgroup;
    private final Logger logger = Logger.getLogger(NettyHttpServer.class.getName());

    public NettyHttpServer() {
        if (Epoll.isAvailable()) {
            this.bossgroup = new EpollEventLoopGroup(1);
            this.workgroup = new EpollEventLoopGroup();
        } else {
            this.bossgroup = new NioEventLoopGroup(1);
            this.workgroup = new NioEventLoopGroup();
        }
    }

    @Override
    public void init() {
        this.setAction("start", "start");
        ArrayList<CommandOption> options = new ArrayList<CommandOption>();
        options.add(new CommandOption("server-port", "", "Server port"));
        ((CommandLine)this.commandLines.get("start")).setOptions(options);
    }

    @Override
    public String version() {
        return null;
    }

    @Override
    public void start() throws ApplicationException {
        if (this.context != null && this.context.getAttribute("--server-port") != null) {
            this.port = Integer.parseInt(this.context.getAttribute("--server-port").toString());
        }
        System.out.println(ApplicationManager.call("--logo", this.context));
        try {
            SslContext sslCtx;
            if (SSL) {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
            } else {
                sslCtx = null;
            }
            ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossgroup, this.workgroup).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
                    }
                    p.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)});
                    p.addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(102400), new ChunkedWriteHandler(), new HttpStaticFileHandler(), new HttpRequestHandler(NettyHttpServer.this.getConfiguration(), new ApplicationContext())});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
            ChannelFuture future = bootstrap.bind(this.port).sync();
            this.logger.info("Netty server(" + this.port + ") started.");
            future.channel().closeFuture().sync();
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
        finally {
            this.stop();
        }
    }

    @Override
    public void stop() {
        this.bossgroup.shutdownGracefully();
        this.workgroup.shutdownGracefully();
    }
}

