/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.system.Configuration;

public class Settings
implements Configuration<String> {
    private static final long serialVersionUID = 8348657988449703373L;
    private static final String FILE = "/application.properties";
    private static String fileName;
    private final Properties properties;
    private boolean overwrite = false;

    public Settings() {
        this(FILE);
        this.overwrite = true;
    }

    public Settings(String file) throws ApplicationRuntimeException {
        fileName = !file.equalsIgnoreCase(FILE) ? file : FILE;
        this.properties = SingletonHolder.INSTANCE.getProperties();
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String get(String property) {
        String value = this.properties.getProperty(property);
        if (value != null && value.startsWith("$_")) {
            return System.getenv(value.substring(2).toUpperCase());
        }
        try {
            assert (value != null);
            byte[] bytes = value.getBytes(StandardCharsets.ISO_8859_1);
            return new String(bytes, StandardCharsets.UTF_8).trim();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void set(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public void remove(String key) {
        this.properties.remove(key);
    }

    @Override
    public Set<String> propertyNames() {
        HashSet<String> sets = new HashSet<String>();
        for (Object o : this.getProperties().keySet()) {
            sets.add(o.toString());
        }
        return sets;
    }

    public void update() throws IOException {
        if (!this.overwrite) {
            return;
        }
        String comments = "Tinystruct Configuration";
        FileOutputStream out = new FileOutputStream(System.getProperty("user.dir") + File.separatorChar + fileName);
        this.properties.store(out, comments);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public String toString() {
        return this.properties.toString();
    }

    private static final class SingletonHolder {
        public static final SingletonHolder INSTANCE = new SingletonHolder();
        private static final Properties properties = new Properties();

        private SingletonHolder() {
        }

        public Properties getProperties() {
            return properties;
        }

        static {
            InputStream in = SingletonHolder.class.getResourceAsStream(fileName);
            if (in != null) {
                try {
                    properties.load(in);
                }
                catch (IOException e) {
                    throw new ApplicationRuntimeException(e.getMessage(), e);
                }
            }
        }
    }
}

