/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.tinystruct.AbstractApplication;
import org.tinystruct.ApplicationException;
import org.tinystruct.handler.DefaultHandler;
import org.tinystruct.handler.Reforward;
import org.tinystruct.http.Request;
import org.tinystruct.http.Response;
import org.tinystruct.http.Session;
import org.tinystruct.system.ApplicationManager;
import org.tinystruct.system.Bootstrap;
import org.tinystruct.system.cli.CommandLine;
import org.tinystruct.system.cli.CommandOption;

public class TomcatServer
extends AbstractApplication
implements Bootstrap {
    private final Logger logger = Logger.getLogger(TomcatServer.class.getName());

    @Override
    public void init() {
        this.setAction("start", "start");
        ArrayList<CommandOption> options = new ArrayList<CommandOption>();
        options.add(new CommandOption("server-port", "", "Server port"));
        ((CommandLine)this.commandLines.get("start")).setOptions(options).setDescription("Start a Tomcat server");
        this.setAction("error", "exceptionCaught");
    }

    @Override
    public void start() throws ApplicationException {
        System.out.println(ApplicationManager.call("--logo", this.context));
        long start = System.currentTimeMillis();
        String webappDirLocation = ".";
        Tomcat tomcat = new Tomcat();
        int webPort = this.context.getAttribute("--server-port") != null ? Integer.parseInt(this.context.getAttribute("--server-port").toString()) : 8080;
        tomcat.setPort(webPort);
        try {
            Context ctx = tomcat.addWebapp("/", new File(webappDirLocation).getAbsolutePath());
            this.logger.info("Configuring app with basedir: " + new File(webappDirLocation).getAbsolutePath());
            Class<DefaultHandler> filterClass = DefaultHandler.class;
            FilterDef filterDef = new FilterDef();
            filterDef.setFilterClass(filterClass.getName());
            filterDef.setFilterName(filterClass.getSimpleName());
            ctx.addFilterDef(filterDef);
            FilterMap filterMap = new FilterMap();
            filterMap.setFilterName(filterClass.getSimpleName());
            filterMap.addURLPattern("/");
            ctx.addFilterMap(filterMap);
            tomcat.start();
            this.logger.info("Server started in " + (System.currentTimeMillis() - start) / 1000L + " seconds");
            tomcat.getServer().await();
        }
        catch (LifecycleException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void stop() {
    }

    public Object exceptionCaught() throws ApplicationException {
        Request request = (Request)this.context.getAttribute("HTTP_REQUEST");
        Response response = (Response)this.context.getAttribute("HTTP_RESPONSE");
        Reforward reforward = new Reforward(request, response);
        this.setVariable("from", reforward.getFromURL());
        Session session = request.getSession();
        if (session.getAttribute("error") != null) {
            ApplicationException exception = (ApplicationException)session.getAttribute("error");
            String message = exception.getRootCause().getMessage();
            if (message != null) {
                this.setVariable("exception.message", message);
            } else {
                this.setVariable("exception.message", "Unknown error");
            }
            this.logger.severe(exception.toString());
            exception.printStackTrace();
            return this.getVariable("exception.message").getValue().toString();
        }
        reforward.forward();
        return "This request is forbidden!";
    }

    @Override
    public String version() {
        return "";
    }
}

