/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.cli;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import org.tinystruct.Application;
import org.tinystruct.system.cli.CommandArgument;
import org.tinystruct.system.cli.CommandOption;
import org.tinystruct.system.util.StringUtilities;

public class CommandLine
implements Comparable<CommandLine> {
    private final String command;
    private String description;
    private final Application app;
    private List<CommandOption> options = new ArrayList<CommandOption>();
    private Set<CommandArgument<String, Object>> arguments = new HashSet<CommandArgument<String, Object>>(16);
    private String example;
    public static final int ARGUMENT_MAX_WIDTH = 77;

    public CommandLine(Application app, String command, String description) {
        this.app = app;
        this.command = command;
        this.description = description;
    }

    public CommandLine(Application app, String command, String description, Set<CommandArgument<String, Object>> arguments, List<CommandOption> options) {
        this(app, command, description);
        this.arguments = arguments;
        this.options = options;
    }

    public Application getApplication() {
        return this.app;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(Object value) {
        this.example = String.format("bin/dispatcher %s/%s\n", this.command, value);
    }

    public List<CommandOption> getOptions() {
        return this.options;
    }

    public CommandLine setOptions(List<CommandOption> options) {
        this.options = options;
        return this;
    }

    public Set<CommandArgument<String, Object>> getArguments() {
        return this.arguments;
    }

    public CommandLine addArgument(CommandArgument<String, Object> argument) {
        this.arguments.add(argument);
        return this;
    }

    public CommandLine setArguments(Set<CommandArgument<String, Object>> arguments) {
        this.arguments = arguments;
        return this;
    }

    public String toString() {
        int max;
        OptionalInt longSizeCommand;
        StringBuilder placeholders = new StringBuilder();
        for (CommandArgument<String, Object> argument : this.arguments) {
            placeholders.append("/{").append(argument.getKey()).append("}");
        }
        StringBuilder help = new StringBuilder("Usage: bin/dispatcher " + this.command + placeholders + " [OPTIONS]\n");
        help.append(this.description).append("\n");
        if (this.example != null) {
            help.append("Example: ").append(this.example).append("\n");
        }
        if (this.arguments.size() > 0) {
            longSizeCommand = this.arguments.stream().mapToInt(o -> ((String)o.getKey()).length()).max();
            max = longSizeCommand.orElse(0);
            help.append("Arguments: \n");
            for (CommandArgument<String, Object> commandArgument : this.arguments) {
                help.append("\t").append(StringUtilities.rightPadding(commandArgument.getKey(), max, ' ')).append("\t").append(commandArgument.getDescription().equals("") ? "Not specified" : commandArgument.getDescription()).append("\n");
            }
        }
        if (this.options.size() > 0) {
            longSizeCommand = this.options.stream().mapToInt(o -> ((String)o.getKey()).length()).max();
            max = longSizeCommand.orElse(0);
            help.append("Options: \n");
            for (CommandArgument<String, Object> commandArgument : this.options) {
                help.append("\t").append(StringUtilities.rightPadding(commandArgument.getKey(), max, ' ')).append("\t").append(commandArgument.getDescription()).append("\n");
            }
        }
        return help + "\n";
    }

    public String getCommand() {
        return this.command;
    }

    public String help() {
        return this.toString();
    }

    @Override
    public int compareTo(CommandLine o) {
        return this.getCommand().compareTo(o.getCommand());
    }
}

