/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.security;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.logging.Logger;
import org.tinystruct.AbstractApplication;

public class KeyPairGenerator
extends AbstractApplication {
    private static final Logger logger = Logger.getLogger(KeyPairGenerator.class.getName());

    @Override
    public void init() {
        this.setAction("generateKeyPair", "getKeyPair");
        this.setTemplateRequired(false);
    }

    public void getKeyPair() {
        String publicKeyFile = "/ca.pub";
        String privateKeyFile = "/ca.pri";
        if (this.context.getAttribute("--public-key") != null) {
            publicKeyFile = this.context.getAttribute("--public-key").toString();
        }
        if (this.context.getAttribute("--private-key") != null) {
            privateKeyFile = this.context.getAttribute("--private-key").toString();
        }
        if (this.context.getAttribute("--password") == null) {
            logger.info("Password is required. please use --password PASSWORD option.");
            return;
        }
        String password = this.context.getAttribute("--password").toString();
        try {
            java.security.KeyPairGenerator keyPairGenerator = java.security.KeyPairGenerator.getInstance("RSA");
            SecureRandom secureRandom = new SecureRandom(password.getBytes());
            keyPairGenerator.initialize(1024, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            byte[] privateKey = keyPair.getPrivate().getEncoded();
            byte[] publicKey = keyPair.getPublic().getEncoded();
            Files.writeString(Paths.get("src", "main", "resources", publicKeyFile), (CharSequence)new String(publicKey), new OpenOption[0]);
            Files.writeString(Paths.get("src", "main", "resources", privateKeyFile), (CharSequence)new String(privateKey), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String version() {
        return null;
    }
}

