/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.security.oauth2;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.component.Builder;
import org.tinystruct.http.URLRequest;
import org.tinystruct.system.security.Authentication;
import org.tinystruct.system.security.Credential;

public class OAuth2Client
implements Authentication {
    boolean status;
    Object token;

    @Override
    public void identify(Credential credential, Map<String, Object> parameters) throws ApplicationException {
        try {
            URL uri = new URL(credential.get("token_uri"));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            headers.put("cache-control", "no-cache");
            String userCredentials = credential.get("client_id") + ":" + credential.get("client_secret");
            String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userCredentials.getBytes()));
            headers.put("Authorization", basicAuth);
            URLRequest request = new URLRequest(uri);
            String resp = new String(request.setHeaders(headers).send(parameters), "utf-8");
            Builder struct = new Builder();
            struct.parse(resp);
            this.token = struct.get("access_token");
            if (this.token != null) {
                this.status = true;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object grant() {
        return this.token;
    }

    @Override
    public boolean approved() {
        return this.status;
    }

    public byte[] resource(URL url, Map<String, Object> parameters) {
        String bearer = "Bearer " + this.token;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Authorization", bearer);
        headers.put("cache-control", "no-cache");
        URLRequest request = new URLRequest(url);
        try {
            return request.setHeaders(headers).send(parameters);
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static enum GRANT_TYPE {
        client_credentials,
        password,
        authorization_code,
        refresh_token,
        token;

    }
}

