/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.template;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.tinystruct.Application;
import org.tinystruct.ApplicationException;
import org.tinystruct.application.Context;
import org.tinystruct.application.Template;
import org.tinystruct.application.Variables;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.template.variable.DataType;
import org.tinystruct.system.template.variable.Variable;
import org.tinystruct.system.util.TextFileLoader;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DefaultTemplate
implements Template {
    private final ConcurrentHashMap<String, Variable<?>> variables = Variables.getInstance();
    private InputStream in;
    private static final String engineName = "JavaScript";
    private final Application app;
    private String view;
    private final ScriptEngine engine;

    public DefaultTemplate(Application app, InputStream in) {
        this.app = app;
        this.engine = SingletonHolder.manager.getEngineByName(engineName);
        if (null != this.engine) {
            this.engine.put("self", this.app);
        }
        this.in = in;
    }

    public DefaultTemplate(Application app, String view) {
        this.app = app;
        this.view = view;
        this.engine = SingletonHolder.manager.getEngineByName(engineName);
        if (null != this.engine) {
            this.engine.put("self", this.app);
            this.engine.put("self.toString", "Please don't execute like this.");
        }
    }

    @Override
    public String getName() {
        return "javax.script.name";
    }

    @Override
    public Variable<?> getVariable(String arg0) {
        return this.variables.get(arg0);
    }

    @Override
    public Map<String, Variable<?>> getVariables() {
        return this.variables;
    }

    @Override
    public String parse() throws ApplicationException {
        Configuration<String> config = this.app.getConfiguration();
        if (this.view == null) {
            TextFileLoader loader = new TextFileLoader(this.in);
            loader.setCharset(config.get("charset"));
            try {
                this.view = loader.getContent().toString();
            }
            catch (ApplicationException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
        if (this.view.trim().length() > 0) {
            Document doc = null;
            try {
                NodeList js;
                int length;
                ByteArrayInputStream in = new ByteArrayInputStream(this.view.getBytes(StandardCharsets.UTF_8));
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                dbf.setValidating(false);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                doc = builder.parse(in);
                ((InputStream)in).close();
                if (this.engine != null && (length = (js = doc.getElementsByTagName("javascript")).getLength()) > 0) {
                    ScriptContext context = this.engine.getContext();
                    StringWriter sw = new StringWriter();
                    PrintWriter writer = new PrintWriter((Writer)sw, true);
                    context.setWriter(writer);
                    for (int i = 0; i < length; ++i) {
                        Node node = js.item(i);
                        Object r = this.engine.eval(node.getTextContent());
                        String result = r != null ? String.valueOf(r) : sw.toString();
                        Text t = doc.createTextNode(result);
                        Node p = node.getParentNode();
                        p.appendChild(t);
                        p.replaceChild(t, node);
                    }
                    ((Writer)writer).close();
                }
            }
            catch (ParserConfigurationException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
            catch (DOMException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
            catch (ScriptException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            writer.write("<!DOCTYPE html>\r\n");
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            try {
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("indent", "no");
                transformer.setOutputProperty("media-type", "xml");
                transformer.setOutputProperty("cdata-section-elements", "script");
                transformer.transform(domSource, result);
            }
            catch (TransformerConfigurationException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
            catch (TransformerException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
            this.view = writer.toString();
            Set<Map.Entry<String, Variable<?>>> sets = this.variables.entrySet();
            Iterator<Map.Entry<String, Variable<?>>> iterator = sets.iterator();
            ArrayList list = new ArrayList();
            Context ctx = this.app.getContext();
            while (iterator.hasNext()) {
                Object value;
                Map.Entry<String, Variable<?>> v = iterator.next();
                Variable<?> variable = v.getValue();
                if (variable.getType() == DataType.ARRAY) {
                    list.add(variable);
                    continue;
                }
                if (v.getKey().startsWith("[%LINK:")) {
                    String baseUrl = ctx != null && ctx.getAttribute("HTTP_HOST") != null ? ctx.getAttribute("HTTP_HOST").toString() : config.get("default.base_url");
                    value = baseUrl + variable.getValue();
                } else {
                    value = variable.getValue().toString();
                }
                value = ((String)value).replace("&", "&amp;");
                this.view = this.view.replace(v.getKey(), (CharSequence)value);
            }
            return this.view;
        }
        return this.view;
    }

    @Override
    public void setVariable(Variable<?> arg0) {
        this.variables.put(arg0.getName(), arg0);
    }

    private static final class SingletonHolder {
        static final ScriptEngineManager manager = new ScriptEngineManager();

        private SingletonHolder() {
        }
    }
}

