/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.template;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.tinystruct.Application;
import org.tinystruct.ApplicationException;
import org.tinystruct.application.Context;
import org.tinystruct.application.Template;
import org.tinystruct.application.Variables;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.template.variable.DataType;
import org.tinystruct.system.template.variable.Variable;
import org.tinystruct.system.util.TextFileLoader;

public class PlainText
implements Template {
    private final ConcurrentHashMap<String, Variable<?>> variables = Variables.getInstance();
    private final Application app;
    private InputStream in;
    private String text;

    public PlainText(Application app, InputStream in) {
        this.app = app;
        this.in = in;
    }

    public PlainText(Application app, String text) {
        this.app = app;
        this.text = text;
    }

    @Override
    public String getName() {
        return "Textplain";
    }

    @Override
    public Variable<?> getVariable(String arg0) {
        return this.variables.get(arg0);
    }

    @Override
    public Map<String, Variable<?>> getVariables() {
        return this.variables;
    }

    @Override
    public String parse() throws ApplicationException {
        Configuration<String> config = this.app.getConfiguration();
        if (this.text == null) {
            TextFileLoader loader = new TextFileLoader(this.in);
            loader.setCharset(config.get("charset"));
            try {
                this.text = loader.getContent().toString();
            }
            catch (ApplicationException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
        Set<Map.Entry<String, Variable<?>>> sets = this.variables.entrySet();
        Iterator<Map.Entry<String, Variable<?>>> iterator = sets.iterator();
        ArrayList list = new ArrayList();
        Context ctx = this.app.getContext();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry<String, Variable<?>> v = iterator.next();
            Variable<?> variable = v.getValue();
            if (variable.getType() == DataType.ARRAY) {
                list.add(variable);
                continue;
            }
            if (v.getKey().startsWith("[%LINK:")) {
                String base_url = ctx != null && ctx.getAttribute("HTTP_HOST") != null ? ctx.getAttribute("HTTP_HOST").toString() : config.get("default.base_url");
                value = base_url + variable.getValue();
            } else {
                value = variable.getValue().toString();
            }
            value = ((String)value).replaceAll("&", "&amp;");
            this.text = this.text.replace(v.getKey(), (CharSequence)value);
        }
        return this.text;
    }

    @Override
    public void setVariable(Variable<?> arg0) {
        this.variables.put(arg0.getName(), arg0);
    }
}

