/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.template.parser;

import org.tinystruct.ApplicationException;
import org.tinystruct.application.Template;
import org.tinystruct.system.template.Parser;
import org.tinystruct.system.template.variable.Variable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArrayParser<T>
implements Parser {
    private final Variable<T[]> variable;
    private final Document doc;

    public ArrayParser(Variable<T[]> variable, Document doc) {
        this.variable = variable;
        this.doc = doc;
    }

    @Override
    public void parse(Template template) throws ApplicationException {
        String elementId = this.variable.getName();
        T[] values = this.variable.getValue();
        Element current = this.doc.getElementById(elementId);
        int n = 0;
        int j = 0;
        if (current == null) {
            throw new ApplicationException("The element has not been defined in your template: id = " + elementId);
        }
        Element list = this.doc.createElement(current.getNodeName());
        while (n < values.length) {
            String v = String.valueOf(values[n++]);
            if (!current.hasChildNodes()) continue;
            int len = current.getChildNodes().getLength();
            for (j = 0; j < len; ++j) {
                Attr attr;
                if (current.getChildNodes().item(j).getNodeType() != 1) continue;
                Node oldChild = current.getChildNodes().item(j);
                Node clone = oldChild.cloneNode(true);
                clone.setTextContent(v);
                if (list.getChildNodes().getLength() == 0) {
                    attr = this.doc.createAttribute("class");
                    attr.setValue("first");
                    clone.getAttributes().setNamedItem(attr);
                } else if (list.getChildNodes().getLength() == values.length - 1) {
                    attr = this.doc.createAttribute("class");
                    attr.setValue("last");
                    clone.getAttributes().setNamedItem(attr);
                }
                list.appendChild(clone);
            }
        }
        current.getParentNode().appendChild(list);
        current.getParentNode().replaceChild(list, current);
    }
}

