/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public abstract class FileFinder
extends SimpleFileVisitor<Path> {
    final PathMatcher pathMatcher;

    public FileFinder(String pattern) {
        this.pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.pathMatcher.matches(file.getFileName())) {
            this.process(file);
        }
        return FileVisitResult.CONTINUE;
    }

    public abstract void process(Path var1);
}

