/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;

public class FileGenerator {
    private static final Logger logger = Logger.getLogger(FileGenerator.class.getName());
    private String filename;
    private StringBuilder content;
    private File file;

    public FileGenerator(String filename) {
        this.filename = filename;
    }

    public FileGenerator(String path, String filename, StringBuilder content) throws ApplicationException {
        if (!new File(path).isDirectory() && !new File(path.toLowerCase()).mkdir()) {
            throw new ApplicationException("Make directory for preparing generate class file directory error");
        }
        this.filename = path + File.separator + filename;
        this.file = new File(this.filename.toLowerCase());
        this.content = content;
    }

    public FileGenerator(String filename, StringBuilder content) throws ApplicationException {
        this.filename = filename;
        this.content = content;
        this.file = new File(this.filename);
    }

    public void save() {
        try (FileOutputStream fos = new FileOutputStream(this.file);
             PrintWriter printer = new PrintWriter(fos, true);){
            printer.write(this.content.toString());
        }
        catch (IOException io) {
            logger.severe("File cannot be created!Exception was happened:" + io.getMessage());
        }
        catch (NullPointerException NullPointer) {
            logger.severe("Please set the file,then use the operator!");
        }
    }

    public StringBuilder read() {
        this.content = new StringBuilder();
        try (FileInputStream in = new FileInputStream(new File(this.filename));
             InputStreamReader reader = new InputStreamReader(in);){
            int i = reader.read();
            while (i != -1) {
                this.content.append((char)i);
                i = reader.read();
            }
        }
        catch (IOException io) {
            logger.severe(io.getMessage());
        }
        return this.content;
    }
}

