/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.tinystruct.ApplicationException;

public class Matrix {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    private Matrix() {
    }

    public static BufferedImage toQRImage(String data, int width, int height) throws ApplicationException {
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        try {
            BitMatrix matrix = multiFormatWriter.encode(data, BarcodeFormat.QR_CODE, width, height, hints);
            BufferedImage image = new BufferedImage(width, height, 1);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
                }
            }
            return image;
        }
        catch (WriterException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public static String getBase64Image(RenderedImage image) throws ApplicationException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write(image, "png", output);
            return new String(Base64.getEncoder().encode(output.toByteArray()));
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }
}

