/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.system.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.tinystruct.ApplicationException;

public class TextFileLoader {
    private File file;
    private InputStream inputStream;
    private String charsetName = "utf-8";

    public TextFileLoader() {
    }

    public TextFileLoader(File file) {
        this.file = file;
    }

    public TextFileLoader(String fileName) {
        this.file = new File(fileName);
    }

    public TextFileLoader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setCharset(String charsetName) {
        this.charsetName = charsetName;
    }

    public StringBuilder getContent() throws ApplicationException {
        StringBuilder content = new StringBuilder();
        try {
            if (this.file != null) {
                this.inputStream = new FileInputStream(this.file);
            }
            if (this.inputStream == null) {
                throw new ApplicationException("The file input stream is not ready.");
            }
            InputStreamReader reader = new InputStreamReader(this.inputStream, this.charsetName);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = bufferedReader.readLine();
            while (line != null) {
                content.append(line).append("\r\n");
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
            reader.close();
            this.inputStream.close();
        }
        catch (FileNotFoundException e) {
            throw new ApplicationException(e.getMessage() + " - " + this.file.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return content;
    }

    public String getFilePath() {
        return this.file.getPath();
    }
}

