/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.transfer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.tinystruct.ApplicationException;
import org.tinystruct.valve.DistributedLock;

public class DistributedHashMap<T>
extends ConcurrentHashMap<String, Queue<T>> {
    private static final long serialVersionUID = 2329878484809829362L;
    private static final int FIXED_LOCK_DATA_SIZE = 44;
    private RandomAccessFile data;
    private int size;
    private DistributedLock lock;
    private String hash;

    public DistributedHashMap() throws IOException {
        try {
            this.lock = new DistributedLock();
            this.hash = "." + this.lock.id();
            this.data = new RandomAccessFile(this.hash, "rw");
            this.size = (int)(this.data.length() / 44L);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Queue<T> get(Object key) {
        try {
            ArrayDeque queue = new ArrayDeque();
            this.data = new RandomAccessFile("." + key, "rw");
            if (this.data.length() >= 44L) {
                this.size = (int)this.data.length() / 44;
                FileLock fileLock = this.data.getChannel().tryLock(0L, Long.MAX_VALUE, false);
                if (fileLock == null || this.size <= 0) return (Queue)super.get(key);
                this.data.seek(0L);
                return (Queue)super.get(key);
            }
            this.size = 0;
            if (queue.size() <= 0) return (Queue)super.get(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Queue)super.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<T> put(String key, Queue<T> value) {
        FileLock fileLock = null;
        try {
            this.lock.lock();
            this.data = new RandomAccessFile(this.hash, "rw");
            if (!this.contains(key)) {
                fileLock = this.data.getChannel().tryLock();
                long length = this.data.length();
                if (null != fileLock) {
                    this.size = length >= 44L ? (int)(length / 44L) : 0;
                    if (this.size > 0) {
                        this.data.seek(this.size * 44);
                        this.data.writeBytes(key);
                        this.data.writeLong(1L);
                    }
                    value = super.put(key, value);
                }
            }
            this.lock.unlock();
        }
        catch (ApplicationException e1) {
            e1.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fileLock != null) {
                    fileLock.release();
                    this.data.close();
                    this.data.getChannel().close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    @Override
    public Queue<T> remove(Object key) {
        try {
            this.lock.lock();
            Paths.get(this.hash, new String[0]).toFile().delete();
            super.remove(key);
            this.lock.unlock();
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Queue<T>>> entrySet() {
        return super.entrySet();
    }
}

