/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.transfer.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public abstract class AbstractReadableByteChannelWrapper
implements ReadableByteChannel {
    protected final ReadableByteChannel rbc;
    private int read;
    private int expected;

    public AbstractReadableByteChannelWrapper(ReadableByteChannel newChannel) {
        this.rbc = newChannel;
    }

    @Override
    public boolean isOpen() {
        return this.rbc.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.rbc.close();
    }

    public int getReceived() {
        return this.read;
    }

    public void setExpected(int expected) {
        this.expected = expected;
    }

    @Override
    public int read(ByteBuffer bb) throws IOException {
        int size = this.rbc.read(bb);
        if (size > 0) {
            this.read += size;
            double progress = this.expected > 0 ? (double)this.read / (double)this.expected * 100.0 : -1.0;
            this.progress(progress);
        }
        return size;
    }

    public abstract void progress(double var1);
}

