/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.transfer.http;

import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.tinystruct.transfer.http.AbstractReadableByteChannelWrapper;

public class ReadableByteChannelWrapper
extends AbstractReadableByteChannelWrapper {
    public ReadableByteChannelWrapper(ReadableByteChannel newChannel, int expected) {
        super(newChannel);
        this.setExpected(expected);
    }

    public ReadableByteChannelWrapper(URL uri) throws Exception {
        super(Channels.newChannel(uri.openStream()));
        this.setExpected(this.length(uri));
    }

    private int length(URL url) throws Exception {
        int length = -1;
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("HEAD");
        length = connection.getContentLength();
        return length;
    }

    @Override
    public void progress(double progress) {
        System.out.print("\r" + String.format("%d bytes received, %.02f%%", this.getReceived(), progress));
    }
}

