/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.transfer.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.tinystruct.ApplicationException;
import org.tinystruct.transfer.Reception;
import org.tinystruct.transfer.Transmission;
import org.tinystruct.transfer.http.Receptor;

public class Transmitter
implements Transmission {
    private final Properties properties = new Properties();
    private Proxy proxy = null;
    private URLConnection connection;

    @Override
    public void set(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public Object get(String name) {
        return this.properties.get(name);
    }

    @Override
    public void proxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public URLConnection getConnection() {
        return this.connection;
    }

    @Override
    public void transmit(Reception reception) throws ApplicationException {
        this.start();
        byte[] p = this.get("parameters").toString().getBytes();
        this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.connection.setRequestProperty("Content-Length", Integer.toString(p.length));
        this.connection.setRequestProperty("Content-Language", "en-US");
        this.connection.setUseCaches(false);
        try (DataOutputStream wr = new DataOutputStream(this.connection.getOutputStream());){
            wr.write(p);
            wr.flush();
            wr.close();
            reception.accept(this);
        }
        catch (MalformedURLException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void start() throws ApplicationException {
        try {
            URL url = (URL)this.get("url");
            this.connection = this.proxy != null ? url.openConnection(this.proxy) : url.openConnection();
            this.connection.setDoOutput(true);
            this.connection.setDoInput(true);
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void stop() throws ApplicationException {
        try {
            this.connection.getOutputStream().close();
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
    }

    public static void main(String[] args) throws ApplicationException, MalformedURLException {
        Transmitter t = new Transmitter();
        t.set("url", new URL("http://ingod.asia/?"));
        t.set("parameters", "q=\u8bd7\u7bc7");
        t.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("135.245.115.123", 8000)));
        Receptor r = new Receptor();
        t.transmit(r);
    }
}

