/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.valve;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.valve.Lock;
import org.tinystruct.valve.LockEventListener;
import org.tinystruct.valve.LockKey;
import org.tinystruct.valve.Watcher;

public class DistributedLock
implements Lock {
    private static final Logger logger = Logger.getLogger(DistributedLock.class.getName());
    private String id;
    private final Watcher watcher = Watcher.getInstance();

    public DistributedLock() {
        this.id = UUID.randomUUID().toString();
        this.watcher.addListener(new LockEventListener(this));
    }

    public DistributedLock(byte[] idb) {
        this.id = new LockKey(idb).value();
        this.watcher.addListener(new LockEventListener(this));
    }

    @Override
    public void lock() throws ApplicationException {
        if (!this.tryLock()) {
            this.lock();
        }
    }

    @Override
    public boolean tryLock() throws ApplicationException {
        return this.tryLock(0L, null);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws ApplicationException {
        if (this.watcher.watch(this)) {
            try {
                if (timeout > 0L) {
                    this.watcher.waitFor(this.id, timeout, unit);
                }
                this.watcher.waitFor(this.id);
            }
            catch (InterruptedException e) {
                throw new ApplicationException(e.getMessage(), e.getCause());
            }
        } else {
            this.watcher.register(this);
        }
        return true;
    }

    @Override
    public void unlock() throws ApplicationException {
        if (this.watcher.watch(this)) {
            this.watcher.unregister(this);
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistributedLock other = (DistributedLock)obj;
        if (this.id == null) {
            return other.id == null;
        }
        return this.id.equals(other.id);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }
}

