/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.valve;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.system.Configuration;
import org.tinystruct.valve.Lock;

public class DistributedRedisLock
implements Lock {
    private static final Logger logger;
    private final RedisURI uri;
    private final StatefulRedisConnection<String, String> redisClient;
    private String id;
    private String value;
    private static String lockScript;
    private static String unlockScript;

    public DistributedRedisLock() {
        this(UUID.randomUUID().toString());
    }

    public DistributedRedisLock(String id) {
        this.uri = RedisURI.Builder.redis((String)"127.0.0.1", (int)6379).withDatabase(0).withTimeout(Duration.ofSeconds(60L)).build();
        this.redisClient = RedisClient.create((RedisURI)this.uri).connect();
        this.id = id;
        this.value = "1";
    }

    public DistributedRedisLock(Configuration<String> settings) {
        this.uri = RedisURI.Builder.redis((String)settings.get("redis.host"), (int)Integer.parseInt(settings.get("redis.port"))).withDatabase(1).withTimeout(Duration.ofSeconds(60L)).build();
        if (settings.get("redis.password") != null) {
            this.uri.setPassword(settings.get("redis.password").toCharArray());
        }
        this.redisClient = RedisClient.create((RedisURI)this.uri).connect();
        this.id = UUID.randomUUID().toString();
        this.value = "1";
    }

    public DistributedRedisLock(Configuration<String> settings, String id) {
        this(settings);
        this.id = id;
    }

    @Override
    public void lock() throws ApplicationException {
        while ((Long)this.redisClient.sync().eval(lockScript, ScriptOutputType.INTEGER, (Object[])new String[]{this.id, this.value}, (Object[])new String[]{"1000"}) == 0L) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean tryLock() throws ApplicationException {
        return (Boolean)this.redisClient.sync().eval(lockScript, ScriptOutputType.INTEGER, (Object[])new String[]{this.id, this.value}, (Object[])new String[]{"1000"});
    }

    @Override
    public boolean tryLock(long l, TimeUnit timeUnit) throws ApplicationException {
        return (Boolean)this.redisClient.sync().eval(lockScript, ScriptOutputType.INTEGER, (Object[])new String[]{this.id, this.value}, (Object[])new String[]{timeUnit.toString()});
    }

    @Override
    public void unlock() throws ApplicationException {
        this.redisClient.sync().eval(unlockScript, ScriptOutputType.INTEGER, (Object[])new String[]{this.id, this.value});
    }

    @Override
    public String id() {
        return this.id;
    }

    static {
        ByteBuffer buff;
        ReadableByteChannel channel;
        InputStream stream;
        logger = Logger.getLogger(DistributedRedisLock.class.getName());
        try {
            stream = Objects.requireNonNull(DistributedRedisLock.class.getResource("/lock.lua")).openStream();
            try {
                channel = Channels.newChannel(stream);
                try {
                    buff = ByteBuffer.allocate(800);
                    channel.read(buff);
                    lockScript = new String(buff.array(), StandardCharsets.UTF_8).trim();
                }
                finally {
                    if (channel != null) {
                        channel.close();
                    }
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Load lock.lua error.", e);
        }
        try {
            stream = Objects.requireNonNull(DistributedRedisLock.class.getResource("/unlock.lua")).openStream();
            try {
                channel = Channels.newChannel(stream);
                try {
                    buff = ByteBuffer.allocate(1024);
                    channel.read(buff);
                    unlockScript = new String(buff.array(), StandardCharsets.UTF_8).trim();
                }
                finally {
                    if (channel != null) {
                        channel.close();
                    }
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Load unlock.lua error.", e);
        }
    }
}

