/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.valve;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.tinystruct.valve.Lock;
import org.tinystruct.valve.Watcher;

class LockEventListener
implements Watcher.EventListener {
    private static final Logger logger = Logger.getLogger(LockEventListener.class.getName());
    private final Lock lock;
    private final CountDownLatch latch;

    public LockEventListener(Lock lock) {
        this.lock = lock;
        this.latch = new CountDownLatch(1);
    }

    @Override
    public void onCreate(String lockId) {
        if (lockId.equalsIgnoreCase(this.lock.id())) {
            logger.info("Created " + lockId);
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onDelete(String lockId) {
        if (lockId.equalsIgnoreCase(this.lock.id())) {
            logger.info("Deleted " + lockId);
            this.latch.countDown();
        }
    }

    @Override
    public String id() {
        return this.lock.id();
    }

    @Override
    public void waitFor() throws InterruptedException {
        this.latch.await();
    }

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }
}

