/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.valve;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.valve.DistributedLock;
import org.tinystruct.valve.Lock;

public final class Watcher
implements Runnable {
    private static final Logger logger = Logger.getLogger(Watcher.class.getName());
    private final String file = ".lock";
    private static final byte[] EMPTY_BYTES = new byte[36];
    private static final int FIXED_LOCK_DATA_SIZE = 44;
    private int[] interspace;
    private int size;
    private final ConcurrentHashMap<String, Lock> locks = new ConcurrentHashMap(8);
    private volatile boolean started = false;
    private volatile boolean stopped = false;
    private final ConcurrentHashMap<String, EventListener> listeners = new ConcurrentHashMap(8);

    public void waitFor(String lockId) throws InterruptedException {
        this.listeners.get(lockId).waitFor();
    }

    public void waitFor(String lockId, long timeout, TimeUnit unit) throws InterruptedException {
        this.listeners.get(lockId).waitFor(timeout, unit);
    }

    public static Watcher getInstance() {
        return SingletonHolder.manager;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[MONITOR]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Watcher() {
        try (RandomAccessFile lockFile = new RandomAccessFile(".lock", "r");){
            this.size = (int)(lockFile.length() / 44L);
            this.interspace = new int[this.size + 1];
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addListener(EventListener listener) {
        this.listeners.put(listener.id(), listener);
    }

    protected void start(boolean daemon) {
        Thread s = new Thread(this);
        s.setDaemon(daemon);
        s.start();
    }

    public boolean watch(Lock lock) throws ApplicationException {
        Class<Watcher> clazz = Watcher.class;
        synchronized (Watcher.class) {
            if (!this.started) {
                this.start(true);
            }
            try {
                Watcher.class.wait();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.locks.contains(lock);
            }
            catch (InterruptedException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
    }

    public void register(Lock lock) throws ApplicationException {
        this.register(lock, 0L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Lock lock, long expiration, TimeUnit tu) throws ApplicationException {
        Class<Watcher> clazz = Watcher.class;
        synchronized (Watcher.class) {
            if (!this.locks.contains(lock)) {
                try (RandomAccessFile lockFile = new RandomAccessFile(".lock", "rw");){
                    String id = lock.id();
                    FileLock fileLock = lockFile.getChannel().tryLock();
                    long length = lockFile.length();
                    if (null != fileLock) {
                        byte[] empty = EMPTY_BYTES;
                        if (length >= 44L) {
                            this.size = (int)(length / 44L);
                            this.interspace = new int[this.size];
                        } else {
                            this.size = 0;
                        }
                        boolean required = true;
                        boolean registerred = false;
                        if (this.size > 0) {
                            int i;
                            int position = 0;
                            for (i = 0; i < this.size; ++i) {
                                position = i * 44;
                                lockFile.seek(position);
                                lockFile.read(empty);
                                if (Arrays.equals(lock.id().getBytes(), empty)) {
                                    if (lockFile.readLong() == 0L) {
                                        lockFile.seek(position + EMPTY_BYTES.length);
                                        lockFile.writeLong(1L);
                                    }
                                    this.interspace[i] = 0;
                                    required = false;
                                    registerred = true;
                                    break;
                                }
                                if (lockFile.readLong() != 0L) continue;
                                this.interspace[i] = 1;
                                required = false;
                            }
                            if (!registerred) {
                                for (i = 0; i < this.size; ++i) {
                                    if (this.interspace[i] != 1) continue;
                                    lockFile.seek(i * 44);
                                    lockFile.writeBytes(id);
                                    lockFile.writeLong(1L);
                                    this.interspace[i] = 0;
                                    required = false;
                                    break;
                                }
                            }
                        }
                        if (required) {
                            lockFile.seek(this.size * 44);
                            lockFile.writeBytes(id);
                            lockFile.writeLong(1L);
                        }
                        this.locks.put(id, lock);
                        if (this.listeners.get(id) != null) {
                            this.listeners.get(id).onCreate(id);
                        }
                        fileLock.release();
                        Watcher.class.notifyAll();
                    }
                }
                catch (FileNotFoundException e) {
                    throw new ApplicationException(e.getMessage(), e.getCause());
                }
                catch (IOException e) {
                    throw new ApplicationException(e.getMessage(), e.getCause());
                }
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Lock lock) throws ApplicationException {
        Class<Watcher> clazz = Watcher.class;
        synchronized (Watcher.class) {
            try (RandomAccessFile lockFile = new RandomAccessFile(".lock", "rw");){
                long length = lockFile.length();
                if (length < 44L) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                FileLock fileLock = lockFile.getChannel().tryLock();
                if (null != fileLock) {
                    byte[] empty = EMPTY_BYTES;
                    this.size = (int)(length / 44L);
                    this.interspace = new int[this.size];
                    int position = 0;
                    String lockId = lock.id();
                    for (int i = 0; i < this.size; ++i) {
                        position = i * 44;
                        lockFile.seek(position);
                        lockFile.read(empty);
                        if (!Arrays.equals(lockId.getBytes(), empty)) continue;
                        lockFile.seek(position + EMPTY_BYTES.length);
                        lockFile.writeLong(0L);
                        if (!this.locks.containsKey(lockId)) break;
                        this.locks.remove(lockId);
                        if (this.listeners.get(lockId) == null) break;
                        this.listeners.get(lockId).onDelete(lockId);
                        break;
                    }
                    fileLock.release();
                    Watcher.class.notifyAll();
                } else {
                    this.unregister(lock);
                }
            }
            catch (FileNotFoundException e) {
                throw new ApplicationException(e.getMessage(), e.getCause());
            }
            catch (IOException e) {
                throw new ApplicationException(e.getMessage(), e.getCause());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock acquire() {
        Class<Watcher> clazz = Watcher.class;
        synchronized (Watcher.class) {
            Lock lock;
            if (null != this.locks && this.locks.size() > 0 && null != (lock = this.locks.elements().nextElement())) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return lock;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new DistributedLock();
        }
    }

    public void stop() {
        this.stopped = this.locks.size() == 0;
    }

    public static interface EventListener {
        public void onCreate(String var1);

        public void onUpdate();

        public void onDelete(String var1);

        public String id();

        public void waitFor() throws InterruptedException;

        public boolean waitFor(long var1, TimeUnit var3) throws InterruptedException;
    }

    private static final class SingletonHolder {
        static final Watcher manager = new Watcher();

        private SingletonHolder() {
        }
    }
}

