/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import org.tinystruct.Application;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.application.Action;
import org.tinystruct.application.ActionRegistry;
import org.tinystruct.application.Container;
import org.tinystruct.application.Context;
import org.tinystruct.application.SharedVariables;
import org.tinystruct.application.Template;
import org.tinystruct.application.Variables;
import org.tinystruct.system.AnnotationProcessor;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Resource;
import org.tinystruct.system.cli.CommandLine;
import org.tinystruct.system.template.DefaultTemplate;
import org.tinystruct.system.template.PlainText;
import org.tinystruct.system.template.variable.ObjectVariable;
import org.tinystruct.system.template.variable.StringVariable;
import org.tinystruct.system.template.variable.Variable;
import org.tinystruct.system.util.StringUtilities;

public abstract class AbstractApplication
implements Application,
Cloneable {
    private static final Container CONTAINER = Container.getInstance();
    protected Map<String, CommandLine> commandLines;
    private final ActionRegistry actionRegistry = ActionRegistry.getInstance();
    private String templateName;
    private final String name;
    protected ThreadLocal<Context> threadLocalContext = ThreadLocal.withInitial(() -> null);
    private Configuration<String> config;
    private String output;
    private boolean templateRequired = true;
    private Locale locale;

    public AbstractApplication() {
        this.name = this.getClass().getName();
        this.templateName = this.name.substring(this.name.lastIndexOf(46) + 1);
        this.commandLines = new HashMap<String, CommandLine>();
    }

    @Override
    public boolean isTemplateRequired() {
        return this.templateRequired;
    }

    public void setTemplateRequired(boolean templateRequired) {
        this.templateRequired = templateRequired;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    public void init(Context context) {
        this.setContext(context);
        String language = context.getAttribute("language") != null ? context.getAttribute("language").toString() : this.config.get("default.language");
        String key = context.getId() + language + File.separatorChar + this.getName();
        if (!CONTAINER.containsKey(key)) {
            try {
                Application clone = (Application)this.clone();
                clone.setContext(context).setLocale(language);
                CONTAINER.put(key, clone);
            }
            catch (CloneNotSupportedException e) {
                throw new ApplicationRuntimeException(e.toString(), e.getCause());
            }
        } else {
            CONTAINER.get(key).setContext(context).setLocale(language);
        }
    }

    @Override
    public Application getInstance(Context context) {
        String language = context.getAttribute("language") != null ? context.getAttribute("language").toString() : this.config.get("default.language");
        return CONTAINER.get(context.getId() + language + File.separatorChar + this.getName());
    }

    @Deprecated
    public void setAction(String path, Action action) {
        this.actionRegistry.set(action);
    }

    @Override
    @Deprecated
    public void setAction(String path, String function) {
        this.actionRegistry.set(this, path, function);
    }

    @Override
    public String setTemplate(Template template) throws ApplicationException {
        return template.parse();
    }

    @Override
    public Configuration<String> getConfiguration() {
        return this.config;
    }

    @Override
    public void setConfiguration(Configuration<String> config) {
        config.set("clsid", this.name);
        config.set("default.language", "zh_CN");
        config.set("language", config.get("default.language"));
        config.set("charset", "utf-8");
        config.set("default.base_url", "/?q=");
        this.setLocale(config.get("default.language"));
        this.config = config;
        this.init();
        AnnotationProcessor annotationProcessor = new AnnotationProcessor(this);
        annotationProcessor.processActionAnnotations();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object invoke(String path) throws ApplicationException {
        return this.invoke(path, null);
    }

    @Override
    public Object invoke(String path, Object[] parameters) throws ApplicationException {
        Action action;
        String method = null;
        Context context = this.threadLocalContext.get();
        if (context != null && context.getAttribute("METHOD") != null) {
            method = context.getAttribute("METHOD").toString();
        }
        if ((action = this.actionRegistry.getAction(path, method)) == null) {
            throw new ApplicationException("Action " + path + " path does not registered.");
        }
        if (parameters == null) {
            return action.execute();
        }
        return action.execute(parameters);
    }

    @Override
    public Context getContext() {
        return this.threadLocalContext.get();
    }

    public void setVariable(String name, String value) {
        this.setVariable(name, value, true);
    }

    public void setVariable(String name, String value, boolean force) {
        if (value == null) {
            value = "";
        }
        StringVariable variable = new StringVariable(name, value);
        this.setVariable(variable, force);
    }

    public void setVariable(Variable<?> variable, boolean force) {
        Variables.getInstance(this.getLocale().toString()).setVariable(variable, force);
    }

    public Variable<?> getVariable(String variable) {
        return Variables.getInstance(this.getLocale().toString()).getVariable(variable);
    }

    public void setSharedVariable(String name, String value) {
        this.setSharedVariable(name, value, this.getLocale().toString());
    }

    public void setSharedVariable(String name, String value, String locale) {
        SharedVariables.getInstance(locale).setVariable(new StringVariable(name, value), true);
    }

    public String setText(String fieldName, Locale locale) {
        String text = this.getProperty(fieldName, locale);
        Variables.getInstance(locale.toString()).setVariable(new StringVariable(fieldName, text), false);
        return text;
    }

    public String setText(String fieldName) {
        String text = this.getProperty(fieldName);
        Variables.getInstance(this.locale.toString()).setVariable(new StringVariable(fieldName, text), false);
        return text;
    }

    public String setText(String fieldName, Object ... args) {
        String text = String.format(this.getProperty(fieldName), args);
        Variables.getInstance(this.locale.toString()).setVariable(new StringVariable(fieldName, text), true);
        return text;
    }

    public String getLink(String path) {
        return this.getLink(path, this.getLocale());
    }

    public String getLink(String path, Locale locale) {
        String baseUrl = this.getContext() != null && this.getContext().getAttribute("HTTP_HOST") != null ? this.getContext().getAttribute("HTTP_HOST").toString() : this.config.get("default.base_url");
        if (this.actionRegistry.paths().contains(path)) {
            if (locale != null) {
                return baseUrl + path + "&lang=" + locale.toLanguageTag();
            }
            return baseUrl + path;
        }
        return "#";
    }

    public String getConfiguration(String propertyName) {
        return this.config.get(propertyName);
    }

    public String getProperty(String propertyName) {
        Resource resource = Resource.getInstance(this.getLocale());
        return resource.getLocaleString(propertyName);
    }

    public String getProperty(String propertyName, Locale locale) {
        Resource resource = Resource.getInstance(locale);
        return resource.getLocaleString(propertyName);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(String locale) {
        String[] local = locale.split("_");
        Locale _locale = new Locale(local[0], local[1]);
        this.setLocale(_locale);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setVariable("language_code", locale.getLanguage());
        this.setVariable("language", locale.toString());
        this.setVariable("LANGUAGE_TAG", locale.toLanguageTag());
        this.setVariable(new ObjectVariable("locale", locale), true);
    }

    @Override
    public String toString() {
        if (!this.templateRequired) {
            return this.name + "@" + Integer.toHexString(this.hashCode());
        }
        InputStream in = null;
        Object templatePath = "UNKNOWN";
        Locale locale = this.getLocale();
        if (locale != null && locale != Locale.CHINA) {
            templatePath = "themes" + File.separatorChar + this.templateName + "_" + String.valueOf(locale) + ".view";
            in = AbstractApplication.class.getClassLoader().getResourceAsStream((String)templatePath);
        }
        if (null == in) {
            templatePath = "themes" + File.separatorChar + this.templateName + ".view";
            in = AbstractApplication.class.getClassLoader().getResourceAsStream((String)templatePath);
        }
        if (null != in) {
            try {
                if (locale != null) {
                    return this.setTemplate(new DefaultTemplate(this, in, Variables.getInstance(locale.toString()).getVariables()));
                }
                return this.setTemplate(new DefaultTemplate((Application)this, in));
            }
            catch (ApplicationException e) {
                throw new ApplicationRuntimeException(e.getMessage(), e);
            }
        }
        if (this.output != null && !this.output.trim().isEmpty()) {
            try {
                String output = locale != null ? this.setTemplate(new PlainText(this, this.output, Variables.getInstance(locale.toString()).getVariables())) : this.setTemplate(new PlainText((Application)this, this.output));
                return output.replace("[%", "").replace("%]", "");
            }
            catch (ApplicationException e) {
                throw new ApplicationRuntimeException(e.getMessage(), e);
            }
        }
        throw new ApplicationRuntimeException("The template " + (String)templatePath + " could not be found and the output has not been set. Reminder: If you don't need a template for this application, please setTemplateRequired(false) in init();");
    }

    public void run() {
    }

    @Override
    @org.tinystruct.system.annotation.Action(value="--help", description="Print help information")
    public String help() {
        StringBuilder builder = new StringBuilder("Usage: bin" + File.separator + "dispatcher COMMAND [OPTIONS]\n");
        StringBuilder commands = new StringBuilder("Commands: \n");
        StringBuilder options = new StringBuilder("Options: \n");
        StringBuilder examples = new StringBuilder("Example(s): \n");
        int length = examples.length();
        int optionsLength = options.length();
        OptionalInt longSizeCommand = this.commandLines.keySet().stream().mapToInt(String::length).max();
        int max = longSizeCommand.orElse(0);
        this.commandLines.forEach((s, commandLine) -> {
            String command = commandLine.getCommand();
            String description = commandLine.getDescription();
            String example = commandLine.getExample();
            if (command.startsWith("--")) {
                options.append("\t").append(StringUtilities.rightPadding(command, max, ' ')).append("\t").append(description).append("\n");
            } else if (command.isEmpty()) {
                builder.append(description).append("\n");
            } else {
                commands.append("\t").append(StringUtilities.rightPadding(command, max, ' ')).append("\t").append(description).append("\n");
            }
            if (example != null && !example.isEmpty()) {
                examples.append(example).append("\n");
            }
        });
        builder.append((CharSequence)commands).append("\n");
        if (optionsLength < options.length()) {
            builder.append((CharSequence)options);
        }
        if (length < examples.length()) {
            builder.append((CharSequence)examples);
        }
        return builder.toString();
    }

    @Override
    public Application setContext(Context context) {
        this.threadLocalContext.set(context);
        return this;
    }

    @Override
    public Map<String, CommandLine> getCommandLines() {
        return this.commandLines;
    }

    @Override
    public void destroy() {
        this.threadLocalContext.remove();
    }
}

